package com.artfess.ljzc.fixed.model;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.model.Tree;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import java.util.ArrayList;
import java.util.List;

/**
 * 固定资产类型信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetFixedType对象", description="固定资产类型信息")
public class BizAssetFixedType extends BaseTreeModel<BizAssetFixedType> implements Tree  {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    //    @JsonIgnore
    @ApiModelProperty(value = "创建人组织名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_ORG_NAME_", fill= FieldFill.INSERT, select=false)
    private String createOrgName;

    //    @JsonIgnore
    @ApiModelProperty(value = "创建人单位ID")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_DEPT_ID_", fill= FieldFill.INSERT, select=false)
    private String createDeptId;

    //    @JsonIgnore
    @ApiModelProperty(value = "创建人单位名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_DEPT_NAME_", fill= FieldFill.INSERT, select=false)
    private String createDeptName;

    //    @JsonIgnore
    @ApiModelProperty(value = "创建人姓名")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_NAME_", fill= FieldFill.INSERT, select=false)
    private String createName;

    //    @JsonIgnore
    @ApiModelProperty(value = "更新人姓名")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateName;

    //    @JsonIgnore
    @ApiModelProperty(value = "更新人组织ID")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_ORG_ID_", fill= FieldFill.UPDATE, select=false)
    private String updateOrgId;

    //    @JsonIgnore
    @ApiModelProperty(value = "更新人组织名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_ORG_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateOrgName;

    //    @JsonIgnore
    @ApiModelProperty(value = "更新人单位ID")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_DEPT_ID_", fill= FieldFill.UPDATE, select=false)
    private String updateDeptId;

    //    @JsonIgnore
    @ApiModelProperty(value = "更新人单位名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_DEPT_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateDeptName;

    //    @JsonIgnore
    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="LAST_TIME_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    @TableLogic
    @Value("0")
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @JsonIgnore
    @TableField(exist=false)
    protected List<BizAssetFixedType> children = new ArrayList<BizAssetFixedType>();

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {
        this.parentId = parentId;
    }
}
