package com.artfess.ljzc.business.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 经营性资产的楼栋信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetBusinessBuilding对象", description="经营性资产的楼栋信息")
public class BizAssetBusinessBuilding extends BizDelModel<BizAssetBusinessBuilding> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择项目", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目ID")
    @TableField("project_id_")
    private String projectId;

    @NotBlank(message = "请输入楼栋名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "楼栋名称")
    @TableField("building_name_")
    private String buildingName;

    @NotBlank(message = "请输入楼栋编码", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "楼栋编码")
    @TableField("building_code_")
    private String buildingCode;

    @NotBlank(message = "请输入楼栋号", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "楼栋号")
    @TableField("building_number_")
    private String buildingNumber;

    @NotNull(message = "请输入楼层数", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "楼层数")
    @TableField("floor_")
    private Integer floor;

    @ApiModelProperty(value = "地面层数")
    @TableField("floor_ground_")
    private Integer floorGround;

    @ApiModelProperty(value = "地下层数")
    @TableField("floor_underground_")
    private Integer floorUnderground;

    @ApiModelProperty(value = "地址经度")
    @TableField("longitude_")
    private String longitude;

    @ApiModelProperty(value = "地址经度")
    @TableField("latitude_")
    private String latitude;

    @ApiModelProperty(value = "产权归属单位ID")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "产权归属单位")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "产权归属单位fullid")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "项目名称")
    @TableField(exist = false)
    private String projectName;

}
