package com.artfess.ljzc.business.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.ljzc.business.model.BizAssetBusinessInfo;
import com.artfess.base.manager.BaseManager;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * 经营性资产的基础信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
public interface BizAssetBusinessInfoManager extends BaseManager<BizAssetBusinessInfo> {

    Boolean audit(List<String> ids,  String status, String assetMsg);

    PageList<BizAssetBusinessInfo> findByPage(QueryFilter<BizAssetBusinessInfo> queryFilter);

    boolean createInfo(BizAssetBusinessInfo t);

    boolean updateInfo(BizAssetBusinessInfo t);

    boolean removeInfo(List<String> ids);

    BizAssetBusinessInfo findById(String id);

    JSONObject bookValue(String fullId);

    JSONObject businessStatistics(String fullId);

    JSONObject gatherStatistics(String fullId);

    List<JSONObject> sourceStatistics(String fullId);

    List<JSONObject> statusStatistics(String fullId);

    List<JSONObject> operationStatistics(String fullId);

    List<JSONObject> typeStatistics(String fullId);

    List<JSONObject> belongStatistics(String fullId);

    List<JSONObject> natureStatistics(String fullId);
}
