/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.TenantMailServerManager;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.model.TenantMailServer;
import com.artfess.uc.model.TenantManage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantMailServer/v1"})
@Api(tags={"\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f"})
@ApiGroup(group={"group_uc"})
public class TenantMailServerController
extends BaseController<TenantMailServerManager, TenantMailServer> {
    @Resource
    TenantMailServerManager tenantMailServerManager;
    @Resource
    BaseContext baseContext;
    @Resource
    TenantManageManager tenantManageManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u5217\u8868")
    public PageList<TenantMailServer> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.tenantMailServerManager.query(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e\u8be6\u60c5")
    public TenantMailServer get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (TenantMailServer)this.tenantMailServerManager.get((Serializable)((Object)id));
    }

    @GetMapping(value={"/getByCurrent"})
    @ApiOperation(value="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e\u8be6\u60c5")
    public TenantMailServer getByCurrent(@ApiParam(name="tenantId", value="\u79df\u6237id", required=true) @RequestParam Optional<String> tenantId) throws Exception {
        String currentTenantId = StringUtil.isEmpty((String)tenantId.orElse(null)) ? this.baseContext.getCurrentTenantId() : tenantId.get();
        TenantMailServer mailServer = this.tenantMailServerManager.getByTenantId(currentTenantId);
        if (BeanUtils.isEmpty((Object)((Object)mailServer))) {
            mailServer = new TenantMailServer();
            mailServer.setTenantId(currentTenantId);
        }
        return mailServer;
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="tenantMailServer", value="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody TenantMailServer tenantMailServer) throws Exception {
        String msg = "\u6dfb\u52a0\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6210\u529f";
        if (StringUtil.isEmpty((String)tenantMailServer.getTenantId())) {
            return new CommonResult(false, "\u79df\u6237id\u3010tenantId\u3011\u5fc5\u586b\uff01");
        }
        TenantMailServer mailServer = this.tenantMailServerManager.getByTenantId(tenantMailServer.getTenantId());
        if (StringUtil.isEmpty((String)tenantMailServer.getId()) && BeanUtils.isEmpty((Object)((Object)mailServer))) {
            this.tenantMailServerManager.create((Model)tenantMailServer);
        } else {
            if (StringUtil.isEmpty((String)tenantMailServer.getId()) && BeanUtils.isNotEmpty((Object)((Object)mailServer))) {
                TenantManage tenant = (TenantManage)this.tenantManageManager.get((Serializable)((Object)mailServer.getTenantId()));
                return new CommonResult(false, "\u79df\u6237\u3010" + tenant.getName() + "\u3011\u5df2\u5b58\u5728\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\uff0c\u4e0d\u9700\u8981\u591a\u6b21\u6dfb\u52a0\uff01");
            }
            this.tenantMailServerManager.update((Model)tenantMailServer);
            msg = "\u66f4\u65b0\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.tenantMailServerManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

