package com.artfess.sysConfig.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 导入导出模板配置表
 *
 * @author wh
 * @company rzx
 * @since 2021-08-04
 */
@ApiModel(value = "导入导出模板配置表 （portal_excel_temp）", description = "导入导出模板配置表")
@TableName("portal_excel_temp")
public class ExcelTemp extends AutoFillModel<ExcelTemp> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_")
    private String id;

    @ApiModelProperty(value = "业务模板编码（由前端传入）")
    @TableField("BIZ_CODE")
    private String bizCode;

    @ApiModelProperty(value = "数据源_ID（指定导入的数据源）")
    @TableField("DB_SOURCE_ID")
    private String dbSourceId;

    @ApiModelProperty(value = "数据库名（指定导入的某个数据库）")
    @TableField("DB_DATABASE")
    private String dbDataBase;

    @ApiModelProperty(value = "数据表名（指定导入的表名）")
    @TableField("DB_TABLE")
    private String dbTable;

    @ApiModelProperty(value = "类型（1：导出  2：导入）")
    @TableField("TYPE")
    private Integer type;

    @ApiModelProperty(value = "导入/导出 物理文件名（不可重复）")
    @TableField("TEMP_FILES")
    private String tempFiles;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBizCode() {
        return bizCode;
    }

    public void setBizCode(String bizCode) {
        this.bizCode = bizCode;
    }

    public String getDbSourceId() {
        return dbSourceId;
    }

    public void setDbSourceId(String dbSourceId) {
        this.dbSourceId = dbSourceId;
    }

    public String getDbDataBase() {
        return dbDataBase;
    }

    public void setDbDataBase(String dbDataBase) {
        this.dbDataBase = dbDataBase;
    }

    public String getDbTable() {
        return dbTable;
    }

    public void setDbTable(String dbTable) {
        this.dbTable = dbTable;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTempFiles() {
        return tempFiles;
    }

    public void setTempFiles(String tempFiles) {
        this.tempFiles = tempFiles;
    }
}
