/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.purchasing.manager.PurchasingRulesManager;
import com.artfess.cgpt.purchasing.model.PurchasingRules;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchasingApplicationRules/v1/"})
@Api(tags={"\u91c7\u8d2d\u5ba1\u6279\u89c4\u5219\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class PurchasingRulesController
extends BaseController<PurchasingRulesManager, PurchasingRules> {
    @PostMapping(value={"/pageAll"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public CommonResult<PageList<PurchasingRules>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<PurchasingRules> queryFilter) {
        PageList<PurchasingRules> result = ((PurchasingRulesManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public CommonResult<PageList<PurchasingRules>> queryByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<PurchasingRules> queryFilter) {
        if (!ContextUtil.getCurrentUserAccount().equals("admin")) {
            queryFilter.addFilter("PROCURE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        PageList<PurchasingRules> result = ((PurchasingRulesManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/getDataById"})
    @ApiOperation(value="M-\u6839\u636eid\u67e5\u8be2\u6570\u636e")
    public CommonResult<PurchasingRules> getDataById(@RequestParam(value="id") String id) {
        PurchasingRules result = ((PurchasingRulesManager)this.baseService).getDetailById(id);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @ApiOperation(value="M-\u4fdd\u5b58\u6216\u66f4\u65b0\u6570\u636e")
    public CommonResult saveOrUpdate(@RequestBody PurchasingRules entity) {
        ((PurchasingRulesManager)this.baseService).saveOrUpdateEntity(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="M-\u6279\u91cf\u5220\u9664")
    public CommonResult remove(@RequestParam List<String> ids) {
        ((PurchasingRulesManager)this.baseService).removeDataByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

