/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.foreignApi.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.foreignApi.vo.WxTemplateVO;
import com.artfess.cgpt.utils.HttpUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserUniteManager;
import com.artfess.uc.params.user.UserVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class WxPublicManager {
    @Value(value="${wxPublic.AppID}")
    private String appID;
    @Value(value="${wxPublic.AppSecret}")
    private String appSecret;
    @Value(value="${wxPublic.getTokenURL}")
    private String getTokenURL;
    @Value(value="${wxPublic.sendTemplateMessageURL}")
    private String sendTemplateMessageURL;
    @Value(value="${wxPublic.grantType}")
    private String grantType;
    @Value(value="${wxPublic.getTemplateURL}")
    private String getTemplateURL;
    @Value(value="${wxPublic.sendAllByTabURL}")
    private String sendAllByTabURL;
    @Value(value="${wxPublic.getUserURL}")
    private String getUserURL;
    @Value(value="${wxPublic.noticeTemplateId}")
    private String noticeTemplateId;
    @Value(value="${wxPublic.taskTemplateId}")
    private String taskTemplateId;
    @Value(value="${wxPublic.getOpenIdURL}")
    private String getOpenIdURL;
    @Value(value="${wxPublic.backUrl}")
    private String backUrl;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private UserManager userManager;
    @Autowired
    private UserUniteManager userUniteManager;
    @Autowired
    PasswordEncoder passwordEncoder;

    public String getWXToken() {
        Object wxToken = this.redisUtil.get("wxToken");
        if (BeanUtils.isNotEmpty((Object)wxToken)) {
            return wxToken.toString();
        }
        String url = this.getTokenURL;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("grant_type", this.grantType);
        param.put("appid", this.appID);
        param.put("secret", this.appSecret);
        String token = HttpUtil.get(url, param);
        String result = JSONObject.parseObject((String)token).getString("access_token");
        if (BeanUtils.isEmpty((Object)result)) {
            throw new BaseException("wx\u83b7\u53d6token\u5931\u8d25\uff1a" + token);
        }
        this.redisUtil.set("wxToken", (Object)result, new Double(5400.0).longValue());
        return result;
    }

    public String sendNoticeTemplateMessage(WxNoticeTemplate template) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, WxTemplateVO> data = new HashMap<String, WxTemplateVO>();
        param.put("touser", "oNXct55AYRl1H1vTk6G-dQf2OQ5A");
        param.put("template_id", this.noticeTemplateId);
        data.put("first", new WxTemplateVO("\u670d\u52a1\u72b6\u6001\u66f4\u65b0\u901a\u77e5"));
        data.put("keyword1", new WxTemplateVO(template.getKeyword1()));
        data.put("keyword2", new WxTemplateVO(template.getKeyword2()));
        data.put("keyword3", new WxTemplateVO(template.getKeyword3() + "\u7ade\u4ef7"));
        data.put("keyword4", new WxTemplateVO(template.getKeyword4()));
        if (BeanUtils.isNotEmpty((Object)template.getUrl())) {
            param.put("url", template.getUrl());
        }
        param.put("data", data);
        return this.sendTemplateMessage(param);
    }

    public String sendTemplateMessage(Map<String, Object> param) {
        String url = this.sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN", this.getWXToken());
        param.put("appid", this.appID);
        System.out.println("\u63a8\u9001\u5fae\u4fe1\u6a21\u7248\u6d88\u606f\u8bf7\u6c42\u53c2\u6570\uff1a" + param);
        String json = HttpUtil.post(replaceUrl, param);
        return json;
    }

    public String sendTemplateMessage(String openId) {
        String url = this.sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN", this.getWXToken());
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, WxTemplateVO> data = new HashMap<String, WxTemplateVO>();
        param.put("touser", openId);
        param.put("template_id", this.noticeTemplateId);
        param.put("appid", this.appID);
        param.put("url", "https://www.baidu.com");
        data.put("first", new WxTemplateVO("\u91cd\u5e86\u6c34\u6cf5\u5382\u6709\u9650\u8d23\u4efb\u516c\u53f8\u5e9f\u65e7\u7269\u8d44\u516c\u5f00\u5904\u7f6e"));
        data.put("keyword1", new WxTemplateVO("202404150001"));
        data.put("keyword2", new WxTemplateVO("\u91cd\u5e86\u6c34\u6cf5\u5382\u6709\u9650\u8d23\u4efb\u516c\u53f8\u5e9f\u65e7\u7269\u8d44\u516c\u5f00\u5904\u7f6e"));
        data.put("keyword3", new WxTemplateVO("\u5e9f\u65e7\u7269\u8d44\u5904\u7f6e"));
        data.put("keyword4", new WxTemplateVO("2024-04-16 16:26:12"));
        param.put("data", data);
        String json = HttpUtil.post(replaceUrl, param);
        return json;
    }

    public String sendTemplateMessage(String accessToken, Map<String, Object> params) {
        String url = this.sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN", accessToken);
        String json = HttpUtil.post(replaceUrl, params);
        return json;
    }

    public Integer getOpenIdList(List<String> openidList, String accessToken, String nextOpenid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("access_token", accessToken);
        params.put("next_openid", nextOpenid);
        String jsonString = HttpUtil.get(this.getUserURL, params);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        JSONArray array = jsonObject.getJSONObject("data").getJSONArray("openid");
        List currentOpenidList = array.toJavaList(String.class);
        openidList.addAll(currentOpenidList);
        Integer total = (Integer)jsonObject.get((Object)"total");
        if (openidList.size() < total) {
            nextOpenid = (String)jsonObject.get((Object)"next_openid");
            this.getOpenIdList(openidList, accessToken, nextOpenid);
        }
        return total;
    }

    public void sendTemplateMessage(WxNoticeTemplate wxTemplate) {
        String url = this.sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN", this.getWXToken());
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, WxTemplateVO> data = new HashMap<String, WxTemplateVO>();
        param.put("template_id", this.noticeTemplateId);
        param.put("appid", this.appID);
        param.put("data", data);
        String title = wxTemplate.getKeyword1();
        String substring = title.substring(title.length() - 2, title.length());
        if (!substring.equals("\u516c\u544a")) {
            title = title + "\u516c\u544a";
        }
        data.put("title", new WxTemplateVO(title));
        param.put("touser", "oo8Ve5jESzxuT1MA1QWStKSeAs5o");
        HttpUtil.post(replaceUrl, param);
    }

    public String sendTemplateMessage(String accessToken, String openId, Map<String, Object> params) {
        params.put("touser", openId);
        String url = this.sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN", accessToken);
        String result = HttpUtil.post(replaceUrl, params);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String apiPath, Map<String, Object> paramMap) {
        PrintWriter out = null;
        InputStream is = null;
        String result = null;
        try {
            URL url = new URL(apiPath);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            out = new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
            out.print(JSONObject.toJSON(paramMap));
            out.flush();
            out.close();
            is = connection.getInputStream();
            int length = connection.getContentLength();
            if (length != -1) {
                byte[] data = new byte[length];
                byte[] temp = new byte[512];
                int readLen = 0;
                int destPos = 0;
                while ((readLen = is.read(temp)) > 0) {
                    System.arraycopy(temp, 0, data, destPos, readLen);
                    destPos += readLen;
                }
                result = new String(data, "UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public JSONObject uploadnews(String title, String bizId, String category, String pubTime, String endRegisTime) {
        String redisToken = this.getWXToken();
        String urlStr = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=ACCESS_TOKEN";
        String replaceUrl = urlStr.replace("ACCESS_TOKEN", redisToken);
        HashMap<String, Object> param = new HashMap<String, Object>();
        ArrayList articles = new ArrayList();
        HashMap<String, Object> article = new HashMap<String, Object>();
        article.put("thumb_media_id", "ipmef7CpnP3K8-31NCqgCruNUBQKRGDhjD21FhHETmAQqm1zsQag-dvRjsRGxnXJ");
        article.put("title", title + "\u53d1\u5e03\u901a\u77e5");
        article.put("show_cover_pic", 1);
        article.put("content_source_url", "http://139.159.250.89:8807/fvue/viewPlat/NoticeDetils?id=" + bizId);
        String content = "<h1>" + title + "</h1>" + "<p>\u7269\u6599\u6240\u5c5e\u5206\u7c7b\uff1a" + category + "</p>" + "<p>\u516c\u544a\u53d1\u5e03\u65f6\u95f4\uff1a" + pubTime + "</p>" + "<p>\u62a5\u540d\u7ed3\u675f\u65f6\u95f4\uff1a" + endRegisTime + "</p>" + "<p>\u5907\u6ce8\uff1a\u6709\u610f\u5411\u53c2\u4e0e\u7ade\u4ef7\u7684\u4f01\u4e1a\u8bf7\u53ca\u65f6\u70b9\u51fb\u4e0b\u65b9\"\u9605\u8bfb\u539f\u6587\"\u6216\u8bbf\u95ee\"\u91cd\u5e86\u673a\u7535\u6570\u667a\u91c7\u8d2d\u5e73\u53f0\"\u5b98\u7f51\u767b\u5f55\u53c2\u4e0e\u62a5\u540d</p>";
        article.put("content", content);
        articles.add(article);
        param.put("articles", articles);
        String json = this.doPost(replaceUrl, param);
        return JSONObject.parseObject((String)json);
    }

    public void uploadNewsAndSendAll(String title, String bizId, String category, String pubTime, String endRegisTime) {
        String redisToken = this.getWXToken();
        String urlStr = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=ACCESS_TOKEN";
        String replaceUrl = urlStr.replace("ACCESS_TOKEN", redisToken);
        HashMap<String, Object> param = new HashMap<String, Object>();
        ArrayList articles = new ArrayList();
        HashMap<String, Object> article = new HashMap<String, Object>();
        article.put("thumb_media_id", "ipmef7CpnP3K8-31NCqgCruNUBQKRGDhjD21FhHETmAQqm1zsQag-dvRjsRGxnXJ");
        article.put("title", title + "\u53d1\u5e03\u901a\u77e5");
        article.put("show_cover_pic", 1);
        article.put("content_source_url", "http://139.159.250.89:8807/fvue/viewPlat/NoticeDetils?id=" + bizId);
        String content = "<h1>" + title + "</h1>" + "<p>\u7269\u6599\u6240\u5c5e\u5206\u7c7b\uff1a" + category + "</p>" + "<p>\u516c\u544a\u53d1\u5e03\u65f6\u95f4\uff1a" + pubTime + "</p>" + "<p>\u62a5\u540d\u7ed3\u675f\u65f6\u95f4\uff1a" + endRegisTime + "</p>" + "<p>\u5907\u6ce8\uff1a\u6709\u610f\u5411\u53c2\u4e0e\u7ade\u4ef7\u7684\u4f01\u4e1a\u8bf7\u53ca\u65f6\u70b9\u51fb\u4e0b\u65b9\"\u9605\u8bfb\u539f\u6587\"\u6216\u8bbf\u95ee\"\u91cd\u5e86\u673a\u7535\u6570\u667a\u91c7\u8d2d\u5e73\u53f0\"\u5b98\u7f51\u767b\u5f55\u53c2\u4e0e\u62a5\u540d</p>";
        article.put("content", content);
        articles.add(article);
        param.put("articles", articles);
        String json = this.doPost(replaceUrl, param);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (BeanUtils.isNotEmpty((Object)jsonObject) && BeanUtils.isNotEmpty((Object)jsonObject.get((Object)"media_id"))) {
            this.sendAllByTab(redisToken, jsonObject.get((Object)"media_id").toString());
        }
    }

    public String sendAllByTab() {
        String url = this.sendAllByTabURL;
        String replaceUrl = url.replace("ACCESS_TOKEN", this.getWXToken());
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Boolean> map1 = new HashMap<String, Boolean>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map1.put("is_to_all", true);
        param.put("filter", map1);
        map2.put("media_id", "uVvtRFku_LsM9BmHYMYddAYhdanPmFhw7MVcRNHDmlekXNCnhmcVuGGoyKop01Kv");
        param.put("mpnews", map2);
        param.put("msgtype", "mpnews");
        String json = this.doPost(replaceUrl, param);
        return json;
    }

    public String sendAllByTab(String token, String mediaId) {
        String url = this.sendAllByTabURL;
        String replaceUrl = url.replace("ACCESS_TOKEN", token);
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Boolean> map1 = new HashMap<String, Boolean>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map1.put("is_to_all", true);
        param.put("filter", map1);
        map2.put("media_id", mediaId);
        param.put("mpnews", map2);
        param.put("msgtype", "mpnews");
        String json = this.doPost(replaceUrl, param);
        return json;
    }

    public void wxEmpower(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuilder builder = new StringBuilder("https://open.weixin.qq.com/connect/oauth2/authorize?appid=");
        builder.append(this.appID);
        builder.append("&redirect_uri=");
        builder.append(URLEncoder.encode("http://agau6a.natappfree.cc/sso/weixinPublic"));
        builder.append("&response_type=code");
        builder.append("&scope=snsapi_userinfo");
        builder.append("&state=STATE#wechat_redirect");
        String url = builder.toString();
        response.sendRedirect(url);
    }

    public CommonResult wxCallBack(String code, Model model) throws Exception {
        System.out.println("code:" + code);
        StringBuilder builder = new StringBuilder("https://api.weixin.qq.com/sns/oauth2/access_token?appid=");
        builder.append(this.appID);
        builder.append("&secret=");
        builder.append(this.appSecret);
        builder.append("&code=");
        builder.append(code);
        builder.append("&grant_type=authorization_code");
        String url = builder.toString();
        JSONObject jsonObject = WxPublicManager.doGetJson(url);
        System.out.println("==========================jsonObject" + jsonObject);
        String token = jsonObject.getString("access_token");
        String openid = jsonObject.getString("openid");
        StringBuilder builder1 = new StringBuilder("https://api.weixin.qq.com/sns/userinfo?access_token=");
        builder1.append(token);
        builder1.append("&openid=");
        builder1.append(openid);
        builder1.append("&lang=zh_CN");
        String infoUrl = builder1.toString();
        JSONObject userInfo = WxPublicManager.doGetJson(infoUrl);
        System.out.println("userInfo=======" + userInfo);
        try {
            CommonResult user = this.userManager.getUserByOpenId(openid);
            if (BeanUtils.isNotEmpty((Object)user.getValue())) {
                model.addAttribute("info", (Object)userInfo);
                model.addAttribute("name", (Object)((UserVo)user.getValue()).getFullname());
                CommonResult response = new CommonResult(true, "\u5df2\u7ed1\u5b9a\u7528\u6237", (Object)user);
                return response;
            }
            model.addAttribute("openid", (Object)openid);
            model.addAttribute("info", (Object)userInfo);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("openid", openid);
            dataMap.put("info", (String)userInfo);
            CommonResult response = new CommonResult(true, "\u6388\u6743\u6210\u529f\uff0c\u8bf7\u7ed1\u5b9a\u7528\u6237", dataMap);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonResult response = new CommonResult(false, "\u6388\u6743\u5931\u8d25");
            return response;
        }
    }

    public static JSONObject doGetJson(String url) throws Exception {
        JSONObject jsonObject = null;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        HttpResponse response = client.execute((HttpUriRequest)get);
        System.out.println(response);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            jsonObject = JSONObject.parseObject((String)result);
        }
        return jsonObject;
    }

    public JSONObject getOpenIdByCode(String code) {
        StringBuilder builder = new StringBuilder(this.getOpenIdURL);
        builder.append("?appid=");
        builder.append(this.appID);
        builder.append("&secret=");
        builder.append(this.appSecret);
        builder.append("&js_code=");
        builder.append(code);
        builder.append("&grant_type=authorization_code");
        String url = builder.toString();
        JSONObject jsonObject = null;
        try {
            jsonObject = WxPublicManager.doGetJson(url);
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6OpenId\u5931\u8d25:", (Throwable)e);
        }
        System.out.println("==========================jsonObject" + jsonObject);
        return jsonObject;
    }

    public void unBindingWx(String openId) {
        QueryWrapper userUniteQW = new QueryWrapper();
        userUniteQW.eq((Object)"OPEN_ID_", (Object)openId);
        this.userUniteManager.remove((Wrapper)userUniteQW);
    }
}

