/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.dao.CalibrationDetailDao;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.manager.CalibrationDetailManager;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.CalibrationDetail;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CalibrationDetailManagerImpl
extends BaseManagerImpl<CalibrationDetailDao, CalibrationDetail>
implements CalibrationDetailManager {
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private MatApprovalDetailsManager maDetailManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalDetailsManager paDetailManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;

    @Override
    public PageList<CalibrationDetail> queryAllByPage(QueryFilter<CalibrationDetail> queryFilter) {
        IPage<CalibrationDetail> result = ((CalibrationDetailDao)this.baseMapper).queryAllByPage((IPage<CalibrationDetail>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<CalibrationDetail>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void calibraZh(BizBiddingQuotation quotation) {
        LambdaQueryWrapper caQW = new LambdaQueryWrapper();
        caQW.eq(CalibrationDetail::getNoticeId, (Object)quotation.getNoticeId());
        super.remove((Wrapper)caQW);
        LambdaQueryWrapper quoQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)quoQW.eq(BizBiddingQuotation::getNoticeId, (Object)quotation.getNoticeId())).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)quotation.getQuotationCompanyId());
        List quoList = this.quotationManager.list((Wrapper)quoQW);
        if (BeanUtils.isEmpty((Object)quoList) || quoList.size() <= 0) {
            throw new BaseException("\u62a5\u4ef7\u6570\u636e\u5f02\u5e38");
        }
        ArrayList<CalibrationDetail> data = new ArrayList<CalibrationDetail>();
        for (BizBiddingQuotation quo : quoList) {
            BizModel detail;
            BizModel notice;
            CalibrationDetail temp = new CalibrationDetail();
            temp.setNoticeId(quo.getNoticeId());
            temp.setVendorId(quo.getQuotationCompanyId());
            temp.setVendorCode(quo.getQuotationCompanyCode());
            temp.setVendorName(quo.getQuotationCompanyName());
            temp.setNoticeDetailedId(quo.getNoticeDetailedId());
            temp.setIsTax(quo.getIsTax());
            temp.setStatus(1);
            temp.setWinBidPrice(quo.getQuotationPrice());
            if (quotation.getNoticeType().equals("1")) {
                notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)quotation.getNoticeId())));
                temp.setNoticeCode(notice.getProjectNumber());
                temp.setNoticeName(notice.getNoticeTitle());
                temp.setProcureOrgId(notice.getProcureOrgId());
                temp.setProcureOrgCode(notice.getProcureOrgCode());
                temp.setProcureOrgName(notice.getProcureOrgName());
                detail = (MatApprovalDetails)((Object)this.maDetailManager.getById((Serializable)((Object)quo.getNoticeDetailedId())));
                temp.setMatId(detail.getMatId());
                temp.setMatPlatcode(detail.getMatPlatcode());
                temp.setMatCategoryCode(detail.getMatCategoryCode());
                temp.setMatCode(detail.getMatCode());
                temp.setMatName(detail.getMatName());
                temp.setMatMaterial(detail.getMatMaterial());
                temp.setMatSpec(detail.getMatSpec());
                temp.setMatNum(detail.getMatNum());
                temp.setMatUnit(detail.getMatUnit());
                temp.setMatBrand(detail.getMatBrand());
                temp.setMatBaseExt(detail.getMatBaseExt());
                temp.setMatOtherExt(detail.getMatOtherExt());
                temp.setTaxRate(detail.getTaxRate());
            } else {
                notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)quotation.getNoticeId())));
                temp.setNoticeCode(notice.getNoticeCode());
                temp.setNoticeName(notice.getNoticeTitle());
                temp.setProcureOrgId(notice.getProcureOrgId());
                temp.setProcureOrgCode(notice.getProcureOrgCode());
                temp.setProcureOrgName(notice.getProcureOrgName());
                detail = (ProjectApprovalDetails)((Object)this.paDetailManager.getById((Serializable)((Object)quo.getNoticeDetailedId())));
                temp.setMatId(detail.getMatId());
                temp.setMatPlatcode(detail.getMatPlatcode());
                temp.setMatCategoryCode(detail.getMatCategoryCode());
                temp.setMatCode(detail.getMatCode());
                temp.setMatName(detail.getMatName());
                temp.setMatMaterial(detail.getMatMaterial());
                temp.setMatSpec(detail.getMatSpec());
                temp.setMatNum(detail.getMatNum());
                temp.setMatUnit(detail.getMatUnit());
                temp.setMatBrand(detail.getMatBrand());
                temp.setMatBaseExt(detail.getMatBaseExt());
                temp.setMatOtherExt(detail.getMatOtherExt());
                temp.setTaxRate(detail.getTaxRate());
            }
            data.add(temp);
        }
        super.saveBatch(data);
    }
}

