package com.artfess.cgpt.winbind.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.manager.CalibrationManager;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.Calibration;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.order.manager.BizRegistrationOrderDetailsManager;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.model.BizRegistrationOrderDetails;
import com.artfess.cgpt.order.vo.OrderDetailsVo;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.violate.manager.BizViolateRecordDetailManager;
import com.artfess.cgpt.violate.manager.BizViolateRecordManager;
import com.artfess.cgpt.violate.model.BizViolateRecord;
import com.artfess.cgpt.violate.model.BizViolateRecordDetail;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.cgpt.winbind.dao.BizWinBiddingNoticeDao;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.cgpt.winbind.vo.BiddingNoticeVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static net.qiyuesuo.sdk.bean.template.ParamType.date;

/**
 * 中标记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizWinBiddingNoticeManagerImpl extends BaseManagerImpl<BizWinBiddingNoticeDao, BizWinBiddingNotice> implements BizWinBiddingNoticeManager {

    @Resource
    private BizWinBiddingNoticeDetaileManager detaileManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager proApprovalManager;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private BizWinBiddingNoticeDetaileManager winBidNoticeDetaileManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private BizRegistrationOrderManager registrationOrderManager;
    @Autowired
    private BizRegistrationOrderDetailsManager registrationOrderDetailsManager;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private BizViolateRecordManager violateRecordManager;
    @Autowired
    private BizViolateRecordDetailManager violateRecordDetailManager;

    @Override
    @Transactional
    public void removeIdList(List<String> ids) {
        List<BizWinBiddingNotice> dataList = super.listByIds(ids);

        //单一来源公示
        List<String> collect = dataList.stream().filter(s -> s.getProcureType() == 5 && BeanUtils.isNotEmpty(s.getApplicationId()))
                .map(s -> s.getApplicationId()).collect(Collectors.toList());
        if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
            //更新采购申请表状态
            LambdaUpdateWrapper<PurchasingApplication> applicationUW = new LambdaUpdateWrapper<>();
            applicationUW.set(PurchasingApplication::getStatus,3)
                    .in(PurchasingApplication::getId,collect)
                    .eq(PurchasingApplication::getIsDele,"0");
            purchasingApplicationManager.update(applicationUW);
        }

        LambdaQueryWrapper<BizWinBiddingNoticeDetaile> winBidNoticeDetailQW = new LambdaQueryWrapper<>();
        winBidNoticeDetailQW.in(BizWinBiddingNoticeDetaile::getWinNoticeId,ids);
        winBidNoticeDetaileManager.remove(winBidNoticeDetailQW);
        accessoryService.removeBySourceIds(ids);

    }

    @Override
    public BizWinBiddingNotice getDetailById(String id) {
        BizWinBiddingNotice result = super.getById(id);
        result.setWinBiddingNoticeDetailList(detaileManager.getByPid(id));
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizWinBiddingNotice entity) {
        List<BizWinBiddingNoticeDetaile> detailList = entity.getWinBiddingNoticeDetailList();
        List<Accessory> accessoryList = entity.getAccessoryList();

        if(BeanUtils.isNotEmpty(entity.getId())){
            detaileManager.removeByPid(entity.getId());
            accessoryService.removeBySourceId(entity.getId());
        }else {
            IUser user = ContextUtil.getCurrentUser();
            entity.setSendUserId(user.getUserId());
            entity.setSendUserAccount(user.getAccount());
            entity.setSendUserName(user.getUsername());
            if(BeanUtils.isNotEmpty(user.getMobile())){
                entity.setSendUserMobile(user.getMobile());
            }
        }

        if(entity.getStatus()==1){
            entity.setSendTime(LocalDateTime.now());
        }

        this.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(detailList) && detailList.size()>0){
            detailList.stream().forEach(s->s.setWinNoticeId(entity.getId()));
            detaileManager.saveOrUpdateBatch(detailList);
        }

        if(entity.getProcureType()==5){
            //单一来源
            if(BeanUtils.isNotEmpty(entity.getApplicationId())){
                //更新采购申请表状态
                LambdaUpdateWrapper<PurchasingApplication> applicationUW = new LambdaUpdateWrapper<>();
                applicationUW.set(PurchasingApplication::getStatus,6)
                        .eq(PurchasingApplication::getId,entity.getApplicationId())
                        .eq(PurchasingApplication::getIsDele,"0");
                purchasingApplicationManager.update(applicationUW);
            }
            //生成项目编号
            if(BeanUtils.isEmpty(entity.getNoticeCode())){
                entity.setNoticeCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"xmxx_xmbh"));
            }

        }

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.stream().forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

    }


    /**
     * 修改状态
     * @param id
     * @param status
     */
    @Override
    @Transactional
    public void updateStatus(String id, Integer status) {
        LambdaUpdateWrapper<BizWinBiddingNotice> uw = new LambdaUpdateWrapper<>();
        uw.set(BizWinBiddingNotice::getStatus,status)
                .eq(BizWinBiddingNotice::getId,id)
                .eq(BizWinBiddingNotice::getIsDele,"0");
        super.update(uw);

        LambdaUpdateWrapper<BizWinBiddingNoticeDetaile> detailUW = new LambdaUpdateWrapper<>();
        detailUW.set(BizWinBiddingNoticeDetaile::getStatus,status)
                .eq(BizWinBiddingNoticeDetaile::getWinNoticeId,id);
        detaileManager.update(detailUW);

        BizWinBiddingNotice winNotice = super.getById(id);
        MatApproval matNotice = matApprovalManager.getById(winNotice.getNoticeId());
        ProjectApproval proNotice = proApprovalManager.getById(winNotice.getNoticeId());

        if(status==1){
            //如果状态为已确认，查询立项是否全部确认完成
            LambdaQueryWrapper<BizWinBiddingNotice> countQW = new LambdaQueryWrapper<>();
            countQW.eq(BizWinBiddingNotice::getStatus,2)
                    .eq(BizWinBiddingNotice::getNoticeId,winNotice.getNoticeId())
                    .eq(BizWinBiddingNotice::getIsDele,"0");
            if(super.count(countQW)==0){
                //如果全部确认完成完成-》更新立项状态为已中标
                if(winNotice.getNoticeType()==1){
                    //物资
                    LambdaUpdateWrapper<MatApproval> matApprovalUW = new LambdaUpdateWrapper<>();
                    matApprovalUW.set(MatApproval::getWinNoticeStatus,2)
                            .eq(MatApproval::getId,winNotice.getNoticeId())
                            .eq(MatApproval::getIsDele,"0");
                    matApprovalManager.update(matApprovalUW);
                }else {
                    //项目
                    LambdaUpdateWrapper<ProjectApproval> approvalUW = new LambdaUpdateWrapper<>();
                    approvalUW.set(ProjectApproval::getWinNoticeStatus,2)
                            .eq(ProjectApproval::getId,winNotice.getNoticeId())
                            .eq(ProjectApproval::getIsDele,"0");
                    proApprovalManager.update(approvalUW);
                }
            }

        }else if(status==4){
            //不同意
            IUser currentUser = ContextUtil.getCurrentUser();

            if(winNotice.getNoticeType()==1){
                //物资
                LambdaUpdateWrapper<MatApproval> matApprovalUW = new LambdaUpdateWrapper<>();
                matApprovalUW.set(MatApproval::getWinNoticeStatus,4)
                        .eq(MatApproval::getId,winNotice.getNoticeId())
                        .eq(MatApproval::getIsDele,"0");
                matApprovalManager.update(matApprovalUW);
            }else {
                //项目
                LambdaUpdateWrapper<ProjectApproval> approvalUW = new LambdaUpdateWrapper<>();
                approvalUW.set(ProjectApproval::getWinNoticeStatus,4)
                        .eq(ProjectApproval::getId,winNotice.getNoticeId())
                        .eq(ProjectApproval::getIsDele,"0");
                proApprovalManager.update(approvalUW);
            }

            //生成违约记录
            BizViolateRecord violateRecord = new BizViolateRecord();
            if(winNotice.getNoticeType()==1){
                //物资
                violateRecord.setNoticeId(matNotice.getId());
                violateRecord.setNoticeCode(matNotice.getProjectNumber());
                violateRecord.setNoticeTitle(matNotice.getNoticeTitle());
                violateRecord.setMatOrgId(matNotice.getProcureOrgId());
                violateRecord.setMatOrgCode(matNotice.getProcureOrgCode());
                violateRecord.setMatOrgName(matNotice.getProcureOrgName());
                if(BeanUtils.isNotEmpty(matNotice.getAffiliatedUserName())){
                    violateRecord.setMatContacts(matNotice.getAffiliatedUserName());
                }
                if(BeanUtils.isNotEmpty(matNotice.getContactsPhone())){
                    violateRecord.setMatContactsPhone(matNotice.getContactsPhone());
                }
            }else {
                //项目
                violateRecord.setNoticeId(proNotice.getId());
                violateRecord.setNoticeCode(proNotice.getNoticeCode());
                violateRecord.setNoticeTitle(proNotice.getNoticeTitle());
                violateRecord.setMatOrgId(proNotice.getProcureOrgId());
                violateRecord.setMatOrgCode(proNotice.getProcureOrgCode());
                violateRecord.setMatOrgName(proNotice.getProcureOrgName());
                if(BeanUtils.isNotEmpty(proNotice.getAffiliatedUserName())){
                    violateRecord.setMatContacts(proNotice.getAffiliatedUserName());
                }
                if(BeanUtils.isNotEmpty(proNotice.getContactsPhone())){
                    violateRecord.setMatContactsPhone(proNotice.getContactsPhone());
                }
            }
            violateRecord.setSupplierOrgId(winNotice.getVendorId());
            violateRecord.setSupplierOrgCode(winNotice.getVendorCode());
            violateRecord.setSupplierOrgName(winNotice.getVendorName());
            violateRecord.setUserId(currentUser.getUserId());
            violateRecord.setUserAccount(currentUser.getAccount());
            violateRecord.setUserName(currentUser.getFullname());
            if(BeanUtils.isNotEmpty(currentUser.getMobile())){
                violateRecord.setUserMobile(currentUser.getMobile());
            }
            violateRecord.setOrgId(violateRecord.getSupplierOrgId());
            violateRecord.setOrgCode(violateRecord.getSupplierOrgCode());
            violateRecord.setOrgName(violateRecord.getSupplierOrgName());
            violateRecord.setProcureType(winNotice.getProcureType());
            violateRecord.setNoticeType(winNotice.getNoticeType());
            violateRecord.setViolateType(2);

            //查询参与表，供应商该立项缴纳的保证金
            LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
            userParticipationQW.eq(UserParticipation::getCompanyId,winNotice.getVendorId())
                    .eq(UserParticipation::getNoticeId,winNotice.getNoticeId())
                    .eq(UserParticipation::getNoticeType,winNotice.getNoticeType())
                    .eq(UserParticipation::getStatus,1)
                    .eq(UserParticipation::getIsDele,"0")
                    .orderByDesc(UserParticipation::getParticipationDate)
                    .last("limit 1");
            UserParticipation userParticipation = userParticipationManager.getBaseMapper().selectOne(userParticipationQW);

            if(BeanUtil.isEmpty(userParticipation)){
                throw new BaseException("未找到参与数据，请联系管理员处理");
            }

            violateRecord.setViolatePrice(userParticipation.getPrice());
            violateRecord.setViolateTime(LocalDateTime.now());
            violateRecord.setPayStatus(1);
            violateRecord.setRevokeStatus(1);
            violateRecord.setWinNoticeId(winNotice.getId());
            violateRecord.setHandleStatus(1);
            violateRecordManager.save(violateRecord);

            //生成违约明细记录
            List<BizWinBiddingNoticeDetaile> winNoticeDetailList = winBidNoticeDetaileManager.getByPid(winNotice.getId());
            if(BeanUtils.isNotEmpty(winNoticeDetailList) && winNoticeDetailList.size()>0){
                List<BizViolateRecordDetail> violateRecordDetailList = new ArrayList<>();

                winNoticeDetailList.stream().forEach(winNoticeDetail->{
                    BizViolateRecordDetail violateRecordDetail = new BizViolateRecordDetail();
                    violateRecordDetail.setVrId(violateRecord.getId());
                    violateRecordDetail.setNoticeId(violateRecord.getNoticeId());
                    violateRecordDetail.setNoticeCode(violateRecord.getNoticeCode());
                    violateRecordDetail.setNoticeTitle(violateRecord.getNoticeTitle());
                    violateRecordDetail.setNoticeDetailId(winNoticeDetail.getNoticeDetailedId());
                    violateRecordDetail.setMatCategoryCode(winNoticeDetail.getMatCategoryCode());
                    violateRecordDetail.setMatId(winNoticeDetail.getMatId());
                    violateRecordDetail.setMatPlatcode(winNoticeDetail.getMatPlatcode());
                    violateRecordDetail.setMatName(winNoticeDetail.getMatName());
                    violateRecordDetail.setMatMaterial(winNoticeDetail.getMatMaterial());
                    violateRecordDetail.setMatSpec(winNoticeDetail.getMatSpec());
                    violateRecordDetail.setMatUnit(winNoticeDetail.getMatUnit());
                    violateRecordDetail.setMatBaseExt(winNoticeDetail.getMatBaseExt());
                    violateRecordDetail.setMatOtherExt(winNoticeDetail.getMatOtherExt());
                    violateRecordDetail.setMatBrand(winNoticeDetail.getMatBrand());
                    violateRecordDetail.setNum(winNoticeDetail.getMatNum());
                    violateRecordDetail.setTaxRate(winNoticeDetail.getTaxRate());
                    violateRecordDetail.setApplicationMethod(winNoticeDetail.getApplicationMethod());
                    violateRecordDetail.setHasQualifications(winNoticeDetail.getHasQualification());
                    violateRecordDetail.setTransactionPrice(winNoticeDetail.getWinBidPrice());
                    violateRecordDetail.setTransactionAmount(winNoticeDetail.getWinBidAmount());
                    violateRecordDetailList.add(violateRecordDetail);
                });
                violateRecordDetailManager.saveBatch(violateRecordDetailList);
            }

        }

    }

    @Override
    @Transactional
    public void pushWinBidNotice(BizWinBiddingNotice entity) {
        //成交通知发布时间
        LocalDateTime sendTime = LocalDateTime.now();
        MatApproval notice = matApprovalManager.getById(entity.getNoticeId());

        //1.更新立项状态为已发布成交通知
        notice.setWinNoticeStatus(2);
        notice.setWinNoticeTime(sendTime);
        //成交有效期时间
        LocalDateTime validityDate = sendTime.plusDays(notice.getWinBidValidity());
        notice.setWinBidValidityTime(validityDate);
        matApprovalManager.updateById(notice);

        IUser currentUser = ContextUtil.getCurrentUser();
        List<BizWinBiddingNoticeDetaile> winBidNoticeDetailList = new ArrayList<>();
        List<String> winOrgId = new ArrayList<>();


        List<BizBidEvaluation> bidEvaList = new ArrayList<>();
        //2.查询定标结果生成成交通知记录
        if(notice.getEvaluationMethod()==2){
            //综合评标法
            if(notice.getEvaluationMode()==1){
                //以物料评标
                QueryFilter<BizBidEvaluation> bidEvaluationQF = QueryFilter.build();
                bidEvaluationQF.addFilter("a.NOTICE_ID_",entity.getNoticeId(), QueryOP.EQUAL);
                bidEvaluationQF.addFilter("a.STATUS_","3", QueryOP.EQUAL);
                bidEvaluationQF.setPageBean(new PageBean(0,-1,false));
                bidEvaList = bidEvaluationManager.getCalibraDetailComprehensive(bidEvaluationQF).getRows();
            }else {
                //以供应商评标
                bidEvaList = bidEvaluationManager.getCalibraDetailMaxScoreById(notice.getId());
            }
        }else {
            //最低价评标法
            QueryFilter<BizBidEvaluation> bidEvaluationQF = QueryFilter.build();
            bidEvaluationQF.addFilter("a.NOTICE_ID_",entity.getNoticeId(), QueryOP.EQUAL);
            bidEvaluationQF.addFilter("a.STATUS_","3", QueryOP.EQUAL);
            bidEvaluationQF.setPageBean(new PageBean(0,-1,false));
            bidEvaList = bidEvaluationManager.getCalibraDetailById(bidEvaluationQF).getRows();
        }

        if(bidEvaList.size()>0){
            Map<String, List<BizBidEvaluation>> evaOrgListMap = bidEvaList.stream().collect(Collectors.groupingBy(BizBidEvaluation::getQuotationOrgId));
            List<BizBidEvaluation> finalBidEvaList = bidEvaList;
            evaOrgListMap.forEach((quoOrgId, evaList) -> {
                winOrgId.add(quoOrgId);
                BizBidEvaluation temp = evaList.get(0);

                BizWinBiddingNotice winBidNotice = new BizWinBiddingNotice();
                winBidNotice.setSendUserId(currentUser.getUserId());
                winBidNotice.setSendUserAccount(currentUser.getAccount());
                winBidNotice.setSendUserName(currentUser.getUsername());
                winBidNotice.setSendUserMobile(currentUser.getMobile());
                winBidNotice.setNoticeId(entity.getNoticeId());
                winBidNotice.setNoticeCode(notice.getProjectNumber());
                winBidNotice.setNoticeName(notice.getNoticeTitle());
                winBidNotice.setNoticeType(1);
                winBidNotice.setProcureOrgId(notice.getProcureOrgId());
                winBidNotice.setProcureOrgCode(notice.getProcureOrgCode());
                winBidNotice.setProcureOrgName(notice.getProcureOrgName());
                winBidNotice.setVendorId(quoOrgId);
                winBidNotice.setVendorCode(temp.getQuotationOrgCode());
                winBidNotice.setVendorName(temp.getQuotationOrgName());
                winBidNotice.setSendTime(sendTime);
                winBidNotice.setConfirmTime(sendTime);
                winBidNotice.setStatus(1);
                winBidNotice.setProcureType(Integer.valueOf(notice.getProcureType()));
                winBidNotice.setIsAgencyProcure(notice.getIsAgencyProcure());
                //设置公示有效期
                winBidNotice.setValidityDate(validityDate.toLocalDate());

                super.save(winBidNotice);

                if(notice.getEvaluationMode()==1){
                    //以物料评标
                    evaList.forEach(s->{
                        BizWinBiddingNoticeDetaile winBidNoticeDetail = new BizWinBiddingNoticeDetaile();

                        if(BeanUtils.isNotEmpty(s.getTenderExplain())){
                            winBidNoticeDetail.setTenderExplain(s.getTenderExplain());
                        }

                        winBidNoticeDetail.setDetailType(4);
                        winBidNoticeDetail.setEvaluationId(s.getId());
                        winBidNoticeDetail.setWinNoticeId(winBidNotice.getId());
                        winBidNoticeDetail.setNoticeId(entity.getNoticeId());
                        winBidNoticeDetail.setNoticeCode(notice.getProjectNumber());
                        winBidNoticeDetail.setNoticeName(notice.getNoticeTitle());
                        winBidNoticeDetail.setNoticeDetailedId(s.getNoticeDetailedId());
                        winBidNoticeDetail.setMatId(s.getMatId());
                        winBidNoticeDetail.setMatPlatcode(s.getMatPlatcode());
                        winBidNoticeDetail.setMatCategoryCode(s.getMatCategoryCode());
                        winBidNoticeDetail.setMatCode(s.getMatCode());
                        winBidNoticeDetail.setMatName(s.getMatName());
                        winBidNoticeDetail.setMatMaterial(s.getMatMaterial());
                        winBidNoticeDetail.setMatSpec(s.getMatSpec());
                        winBidNoticeDetail.setMatNum(s.getMatNum());
                        winBidNoticeDetail.setMatUnit(s.getMatUnit());
                        winBidNoticeDetail.setDemandDate(s.getDemandDate());
                        winBidNoticeDetail.setMatBrand(s.getMatBrand());
                        winBidNoticeDetail.setMatBaseExt(s.getMatBaseExt());
                        winBidNoticeDetail.setMatOtherExt(s.getMatOtherExt());
                        winBidNoticeDetail.setIsTax(s.getIsTax());
                        winBidNoticeDetail.setTaxRate(s.getTaxRate());
                        winBidNoticeDetail.setStatus(1);
                        winBidNoticeDetail.setShareAllocationRate(s.getShareAllocationRate());
                        winBidNoticeDetail.setShareAllocationNum(s.getShareAllocationNum());
                        winBidNoticeDetail.setWinBidPrice(s.getQuotationPrice());
                        winBidNoticeDetail.setWinBidAmount(winBidNoticeDetail.getWinBidPrice().multiply(winBidNoticeDetail.getShareAllocationNum()));
                        winBidNoticeDetail.setPlanCode(s.getPlanCode());
                        if(BeanUtils.isNotEmpty(s.getAcceptanceTime())){
                            winBidNoticeDetail.setAcceptanceTime(s.getAcceptanceTime());
                        }
                        if(BeanUtils.isNotEmpty(s.getPendingTime())){
                            winBidNoticeDetail.setPendingTime(s.getPendingTime());
                        }
                        if(BeanUtils.isNotEmpty(s.getMatRemarks())){
                            winBidNoticeDetail.setPurNote(s.getMatRemarks());
                        }
                        if(BeanUtils.isNotEmpty(s.getUnloadAddress())){
                            winBidNoticeDetail.setUnloadAddress(s.getUnloadAddress());
                        }
                        winBidNoticeDetail.setApplicationId(s.getPurchasingApplicationId());
                        winBidNoticeDetail.setApplicationDetailId(s.getPurchasingApplicationDetailId());
                        winBidNoticeDetail.setQuotationMethod(notice.getQuotationMethod());
                        winBidNoticeDetailList.add(winBidNoticeDetail);
                    });
                }else {
                    //以供应商评标
                    //查询报价明细
                    QueryFilter<BizBiddingQuotation> quoQF = QueryFilter.build();
                    quoQF.addFilter("quo.NOTICE_ID_",notice.getId(),QueryOP.EQUAL);
                    quoQF.addFilter("quo.QUOTATION_ROUNDS_",notice.getQuotationRoundsNum(),QueryOP.EQUAL);
                    quoQF.addFilter("quo.QUOTATION_COMPANY_ID_",quoOrgId,QueryOP.EQUAL);
                    quoQF.setPageBean(new PageBean(0,-1,false));
                    List<BizBiddingQuotation> quoList = quotationManager.pageMatDetail(quoQF).getRows();
                    BizBidEvaluation bidEvaluation = finalBidEvaList.stream().filter(s -> s.getQuotationOrgId().equals(quoOrgId)).collect(Collectors.toList()).get(0);
                    quoList.stream().forEach(s->{
                        BizWinBiddingNoticeDetaile winBidNoticeDetail = new BizWinBiddingNoticeDetaile();

                        if(BeanUtils.isNotEmpty(s.getTenderExplain())){
                            winBidNoticeDetail.setTenderExplain(s.getTenderExplain());
                        }

                        winBidNoticeDetail.setDetailType(4);
                        winBidNoticeDetail.setEvaluationId(bidEvaluation.getId());
                        winBidNoticeDetail.setWinNoticeId(winBidNotice.getId());
                        winBidNoticeDetail.setNoticeId(entity.getNoticeId());
                        winBidNoticeDetail.setNoticeCode(notice.getProjectNumber());
                        winBidNoticeDetail.setNoticeName(notice.getNoticeTitle());
                        winBidNoticeDetail.setNoticeDetailedId(s.getNoticeDetailedId());
                        winBidNoticeDetail.setMatId(s.getMatId());
                        winBidNoticeDetail.setMatPlatcode(s.getMatPlatcode());
                        winBidNoticeDetail.setMatCategoryCode(s.getMatCategoryCode());
                        winBidNoticeDetail.setMatCode(s.getMatCode());
                        winBidNoticeDetail.setMatName(s.getMatName());
                        winBidNoticeDetail.setMatMaterial(s.getMatMaterial());
                        winBidNoticeDetail.setMatSpec(s.getMatSpec());
                        winBidNoticeDetail.setMatNum(s.getMatNum());
                        winBidNoticeDetail.setMatUnit(s.getMatUnit());
                        winBidNoticeDetail.setDemandDate(s.getDemandDate());
                        winBidNoticeDetail.setMatBrand(s.getMatBrand());
                        winBidNoticeDetail.setMatBaseExt(s.getMatBaseExt());
                        winBidNoticeDetail.setMatOtherExt(s.getMatOtherExt());
                        winBidNoticeDetail.setTaxRate(s.getTaxRate());
                        winBidNoticeDetail.setStatus(1);
                        winBidNoticeDetail.setShareAllocationRate(bidEvaluation.getShareAllocationRate());
                        winBidNoticeDetail.setShareAllocationNum(winBidNoticeDetail.getShareAllocationRate().divide(new BigDecimal("100")).multiply(winBidNoticeDetail.getMatNum()));
                        winBidNoticeDetail.setWinBidPrice(s.getQuotationPrice());
                        winBidNoticeDetail.setWinBidAmount(s.getQuotationAmount());
                        winBidNoticeDetail.setPlanCode(s.getPlanCode());
                        winBidNoticeDetail.setIsTax(s.getIsTax());
                        if(BeanUtils.isNotEmpty(s.getAcceptanceTime())){
                            winBidNoticeDetail.setAcceptanceTime(s.getAcceptanceTime());
                        }
                        if(BeanUtils.isNotEmpty(s.getPendingTime())){
                            winBidNoticeDetail.setPendingTime(s.getPendingTime());
                        }
                        if(BeanUtils.isNotEmpty(s.getPurNote())){
                            winBidNoticeDetail.setPurNote(s.getPurNote());
                        }
                        if(BeanUtils.isNotEmpty(s.getUnloadAddress())){
                            winBidNoticeDetail.setUnloadAddress(s.getUnloadAddress());
                        }
                        winBidNoticeDetail.setApplicationId(s.getPurchasingApplicationId());
                        winBidNoticeDetail.setApplicationDetailId(s.getPurchasingApplicationDetailId());
                        winBidNoticeDetail.setQuotationMethod(notice.getQuotationMethod());
                        winBidNoticeDetailList.add(winBidNoticeDetail);
                    });
                }

            });

            if(winBidNoticeDetailList.size()>0){
                winBidNoticeDetaileManager.saveBatch(winBidNoticeDetailList);
            }
        }

        if(BeanUtils.isNotEmpty(notice.getBond()) && notice.getBond().compareTo(BigDecimal.ZERO)>0){
            //查询参与表 该立项已参与且未中标的供应商
            LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
            userParticipationQW.eq(UserParticipation::getNoticeId,notice.getId())
                    .notIn(winOrgId.size()>0,UserParticipation::getCompanyId,winOrgId)
                    .eq(UserParticipation::getStatus,1)
                    .gt(UserParticipation::getPrice,0)
                    .eq(UserParticipation::getType,1)
                    .eq(UserParticipation::getIsDele,"0");
            List<UserParticipation> userParticipationList = userParticipationManager.list(userParticipationQW);
            if(BeanUtils.isNotEmpty(userParticipationList) && userParticipationList.size()>0){
                //退还保证金
                for(UserParticipation userPart : userParticipationList){
                    if(BeanUtils.isEmpty(userPart.getRegistrationOrderId())){
                        continue;
                    }
                    //1.查询保证金支付记录
                    BizRegistrationOrder regisOrder = registrationOrderManager.getById(userPart.getRegistrationOrderId());
                    //2.生成退还保证金记录
                    BizRegistrationOrder refundRegisOrder = new BizRegistrationOrder();
                    refundRegisOrder.setParticipationId(userPart.getId());
                    String orderNumber = BizUtils.getNextSerialNumber(systemConfigFeignService, "zfjl_ddh");
                    refundRegisOrder.setOrderNumber(orderNumber);
                    refundRegisOrder.setPayStatus(3);
                    refundRegisOrder.setRefundStatus(1);
                    refundRegisOrder.setNoticeId(notice.getId());
                    refundRegisOrder.setNoticeType(1);
                    IUser user = ContextUtil.getCurrentUser();
                    refundRegisOrder.setUserId(user.getUserId());
                    refundRegisOrder.setUserAccount(user.getAccount());
                    refundRegisOrder.setUserName(user.getFullname());
                    if(BeanUtils.isNotEmpty(user.getMobile())) {
                        refundRegisOrder.setUserPhone(user.getMobile());
                    }
                    refundRegisOrder.setPayType(6);
                    Org payOrg = orgManager.getByCode("00001513");
                    if(BeanUtils.isEmpty(payOrg)){
                        throw new BaseException("未找到编号为【00001513】企业信息，请联系相关人员注册");
                    }
                    refundRegisOrder.setPayUnitId(regisOrder.getCollectUnitId());
                    refundRegisOrder.setPayUnitCode(regisOrder.getCollectUnitCode());
                    refundRegisOrder.setPayUnitName(regisOrder.getCollectUnitName());
                    refundRegisOrder.setPayAccount(regisOrder.getCollectAccount());
                    refundRegisOrder.setPayAccountBank(regisOrder.getCollectAccountBank());
                    refundRegisOrder.setPayTime(LocalDateTime.now());
                    refundRegisOrder.setPayTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
                    refundRegisOrder.setPayAmount(regisOrder.getPayAmount());
                    refundRegisOrder.setCollectUnitId(regisOrder.getPayUnitId());
                    refundRegisOrder.setCollectUnitCode(regisOrder.getPayUnitCode());
                    refundRegisOrder.setCollectUnitName(regisOrder.getPayUnitName());
                    refundRegisOrder.setCollectAccount(regisOrder.getPayAccount());
                    refundRegisOrder.setCollectAccountBank(regisOrder.getPayAccountBank());
                    refundRegisOrder.setCollectTime(regisOrder.getPayTime());
                    refundRegisOrder.setCollectTimer(regisOrder.getPayTimer());
                    refundRegisOrder.setPayDescribe("退还保证金");
                    registrationOrderManager.save(refundRegisOrder);
                    List<BizRegistrationOrderDetails> detailedList = new ArrayList<>();
                    ForeignResponseVo res = null;

                    //保证金
                    TransVo transVo = new TransVo();
                    try {
                        BeanUtils.copyNotNullProperties(transVo,refundRegisOrder);
                    } catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        throw new BaseException(e.getMessage());
                    }
                    transVo.setStatementsCode(refundRegisOrder.getOrderNumber());
                    transVo.setDepositPaymentStatus(refundRegisOrder.getPayStatus());

                    BizRegistrationOrderDetails detail = new BizRegistrationOrderDetails();
                    detail.setRegistrationOrderId(refundRegisOrder.getId());
                    detail.setRegistrationOrderNumber(refundRegisOrder.getOrderNumber());

                    detail.setUserId(refundRegisOrder.getUserId());
                    detail.setUserName(refundRegisOrder.getUserName());
                    detail.setUserAccount(refundRegisOrder.getUserAccount());
                    if(BeanUtils.isNotEmpty(refundRegisOrder.getUserPhone())) {
                        detail.setUserPhone(refundRegisOrder.getUserPhone());
                    }
                    detail.setCompanyId(refundRegisOrder.getPayUnitId());
                    detail.setCompanyCode(refundRegisOrder.getPayUnitCode());
                    detail.setCompanyName(refundRegisOrder.getPayUnitName());
                    detail.setNoticeId(refundRegisOrder.getNoticeId());
                    detail.setNoticeType(refundRegisOrder.getNoticeType());
                    detail.setNoticeTitle(notice.getNoticeTitle());
                    detail.setPayName(notice.getNoticeTitle());
                    detail.setRechargeNumber(BigDecimal.ONE);
                    detail.setRechargePrice(refundRegisOrder.getPayAmount());
                    detail.setSalesCompanyId(refundRegisOrder.getCollectUnitId());
                    detail.setSalesCompanyCode(refundRegisOrder.getCollectUnitCode());
                    detail.setSalesCompanyName(refundRegisOrder.getCollectUnitName());
                    detailedList.add(detail);

                    List<OrderDetailsVo> orderDetailsList = new ArrayList<>();
                    OrderDetailsVo orderDetailsVo = new OrderDetailsVo();
                    try {
                        BeanUtils.copyNotNullProperties(orderDetailsVo,detail);
                    } catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        System.out.println("订单明细转换错误："+e.getMessage());
                        throw new BaseException("订单明细转换错误："+e.getMessage());
                    }
                    orderDetailsVo.setPayType(6);
                    orderDetailsList.add(orderDetailsVo);
                    transVo.setOrderDetails(orderDetailsList);

                    //3.调用支付平台内部支付接口
                    res = foreignCallService.callPay(transVo, 1);

                    if(BeanUtil.isEmpty(res)) {
                        throw new BaseException("调用[支付平台]支付失败");
                    }
                    if(!res.getCode().equals("0")) {
                        throw new BaseException("调用[支付平台]支付失败:"+ res.getMsg());
                    }

                    if(detailedList.size()>0){
                        registrationOrderDetailsManager.saveBatch(detailedList);
                    }

                    regisOrder.setRefundStatus(3);
                    regisOrder.setRefundOrderId(refundRegisOrder.getId());
                    registrationOrderManager.updateById(regisOrder);
                    //设置退款id
                    userPart.setRefundRegistrationOrderId(refundRegisOrder.getId());
                    userPart.setRefundRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
                }
                userParticipationManager.updateBatchById(userParticipationList);
            }

        }

    }

    @Override
    @Transactional
    public void pushWinBidNoticePro(BizWinBiddingNotice entity) {
        //成交通知发布时间
        LocalDateTime sendTime = LocalDateTime.now();
        ProjectApproval notice = proApprovalManager.getById(entity.getNoticeId());

        //1.更新立项状态为已发布成交通知
        notice.setWinNoticeStatus(3);
        notice.setWinNoticeTime(sendTime);
        //成交有效期时间
        LocalDateTime validityDate = sendTime.plusDays(notice.getWinBidValidity());
        notice.setWinBidValidityTime(validityDate);
        proApprovalManager.updateById(notice);

        IUser currentUser = ContextUtil.getCurrentUser();
        List<BizWinBiddingNoticeDetaile> winBidNoticeDetailList = new ArrayList<>();
        List<String> winOrgId = new ArrayList<>();


        List<BizBidEvaluation> bidEvaList = new ArrayList<>();
        //2.查询定标结果生成成交通知记录
        if(notice.getEvaluationMethod()==2){
            //综合评标法
            if(notice.getEvaluationMode()==1){
                //以物料评标
                QueryFilter<BizBidEvaluation> bidEvaluationQF = QueryFilter.build();
                bidEvaluationQF.addFilter("a.NOTICE_ID_",entity.getNoticeId(), QueryOP.EQUAL);
                bidEvaluationQF.addFilter("a.STATUS_","3", QueryOP.EQUAL);
                bidEvaluationQF.setPageBean(new PageBean(0,-1,false));
                bidEvaList = bidEvaluationManager.getCalibraDetailComprehensivePro(bidEvaluationQF).getRows();
            }else {
                //以供应商评标
                bidEvaList = bidEvaluationManager.getCalibraDetailMaxScoreByIdPro(notice.getId());
            }
        }else {
            //最低价评标法
            QueryFilter<BizBidEvaluation> bidEvaluationQF = QueryFilter.build();
            bidEvaluationQF.addFilter("a.NOTICE_ID_",entity.getNoticeId(), QueryOP.EQUAL);
            bidEvaluationQF.addFilter("a.STATUS_","3", QueryOP.EQUAL);
            bidEvaluationQF.setPageBean(new PageBean(0,-1,false));
            bidEvaList = bidEvaluationManager.getCalibraDetailByIdPro(bidEvaluationQF).getRows();
        }

        if(bidEvaList.size()>0){
            Map<String, List<BizBidEvaluation>> evaOrgListMap = bidEvaList.stream().collect(Collectors.groupingBy(BizBidEvaluation::getQuotationOrgId));
            List<BizBidEvaluation> finalBidEvaList = bidEvaList;
            evaOrgListMap.forEach((quoOrgId, evaList) -> {
                winOrgId.add(quoOrgId);
                BizBidEvaluation temp = evaList.get(0);

                BizWinBiddingNotice winBidNotice = new BizWinBiddingNotice();
                winBidNotice.setSendUserId(currentUser.getUserId());
                winBidNotice.setSendUserAccount(currentUser.getAccount());
                winBidNotice.setSendUserName(currentUser.getUsername());
                winBidNotice.setSendUserMobile(currentUser.getMobile());
                winBidNotice.setNoticeId(entity.getNoticeId());
                winBidNotice.setNoticeCode(notice.getNoticeCode());
                winBidNotice.setNoticeName(notice.getNoticeTitle());
                winBidNotice.setNoticeType(2);
                winBidNotice.setProcureOrgId(notice.getProcureOrgId());
                winBidNotice.setProcureOrgCode(notice.getProcureOrgCode());
                winBidNotice.setProcureOrgName(notice.getProcureOrgName());
                winBidNotice.setVendorId(quoOrgId);
                winBidNotice.setVendorCode(temp.getQuotationOrgCode());
                winBidNotice.setVendorName(temp.getQuotationOrgName());
                winBidNotice.setSendTime(sendTime);
                winBidNotice.setStatus(2);
                winBidNotice.setProcureType(Integer.valueOf(notice.getProcureType()));
                winBidNotice.setIsAgencyProcure(0);
                //设置公示有效期
                winBidNotice.setValidityDate(validityDate.toLocalDate());

                super.save(winBidNotice);

                if(notice.getEvaluationMode()==1){
                    //以物料评标
                    evaList.forEach(s->{
                        BizWinBiddingNoticeDetaile winBidNoticeDetail = new BizWinBiddingNoticeDetaile();

                        if(BeanUtils.isNotEmpty(s.getTenderExplain())){
                            winBidNoticeDetail.setTenderExplain(s.getTenderExplain());
                        }

                        winBidNoticeDetail.setEvaluationId(s.getId());
                        winBidNoticeDetail.setWinNoticeId(winBidNotice.getId());
                        winBidNoticeDetail.setNoticeId(entity.getNoticeId());
                        winBidNoticeDetail.setNoticeCode(notice.getNoticeCode());
                        winBidNoticeDetail.setNoticeName(notice.getNoticeTitle());
                        winBidNoticeDetail.setNoticeDetailedId(s.getNoticeDetailedId());
                        winBidNoticeDetail.setMatId(s.getMatId());
                        winBidNoticeDetail.setMatPlatcode(s.getMatPlatcode());
                        winBidNoticeDetail.setMatCategoryCode(s.getMatCategoryCode());
                        winBidNoticeDetail.setMatCode(s.getMatCode());
                        winBidNoticeDetail.setMatName(s.getMatName());
                        winBidNoticeDetail.setMatMaterial(s.getMatMaterial());
                        winBidNoticeDetail.setMatSpec(s.getMatSpec());
                        winBidNoticeDetail.setMatNum(s.getMatNum());
                        winBidNoticeDetail.setMatUnit(s.getMatUnit());
                        winBidNoticeDetail.setDemandDate(s.getDemandDate());
                        winBidNoticeDetail.setMatBrand(s.getMatBrand());
                        winBidNoticeDetail.setMatBaseExt(s.getMatBaseExt());
                        winBidNoticeDetail.setMatOtherExt(s.getMatOtherExt());
                        winBidNoticeDetail.setIsTax(s.getIsTax());
                        winBidNoticeDetail.setTaxRate(s.getTaxRate());
                        winBidNoticeDetail.setStatus(2);
                        winBidNoticeDetail.setShareAllocationRate(s.getShareAllocationRate());
                        winBidNoticeDetail.setShareAllocationNum(s.getShareAllocationNum());
                        winBidNoticeDetail.setWinBidPrice(s.getQuotationPrice());
                        winBidNoticeDetail.setWinBidAmount(winBidNoticeDetail.getWinBidPrice().multiply(winBidNoticeDetail.getShareAllocationNum()));
                        winBidNoticeDetail.setPlanCode(s.getPlanCode());
                        if(BeanUtils.isNotEmpty(s.getAcceptanceTime())){
                            winBidNoticeDetail.setAcceptanceTime(s.getAcceptanceTime());
                        }
                        if(BeanUtils.isNotEmpty(s.getPendingTime())){
                            winBidNoticeDetail.setPendingTime(s.getPendingTime());
                        }
                        if(BeanUtils.isNotEmpty(s.getMatRemarks())){
                            winBidNoticeDetail.setPurNote(s.getMatRemarks());
                        }
                        if(BeanUtils.isNotEmpty(s.getUnloadAddress())){
                            winBidNoticeDetail.setUnloadAddress(s.getUnloadAddress());
                        }
                        winBidNoticeDetail.setApplicationId(s.getPurchasingApplicationId());
                        winBidNoticeDetail.setApplicationDetailId(s.getPurchasingApplicationDetailId());
                        winBidNoticeDetail.setQuotationMethod(notice.getQuotationMethod());

                        winBidNoticeDetail.setProjectSourceType(s.getProjectSourceType());
                        winBidNoticeDetail.setProjectInfoId(s.getProjectInfoId());
                        winBidNoticeDetail.setProjectLedgerId(s.getProjectLedgerId());
                        winBidNoticeDetail.setProjectLedgerCode(s.getProjectLedgerCode());
                        winBidNoticeDetail.setDetailType(s.getDetailType());
                        winBidNoticeDetail.setServiceStartTime(s.getServiceStartTime());
                        winBidNoticeDetail.setServiceEndTime(s.getServiceEndTime());
                        winBidNoticeDetail.setBuildingArea(s.getBuildingArea());
                        winBidNoticeDetail.setConstructionEngineering(s.getConstructionEngineering());
                        winBidNoticeDetail.setEquipmentProcurement(s.getEquipmentProcurement());
                        winBidNoticeDetail.setOtherExpenses(s.getOtherExpenses());
                        winBidNoticeDetail.setEquipmentClassification(s.getEquipmentClassification());
                        winBidNoticeDetail.setTechnicalRequirement(s.getTechnicalRequirement());
                        winBidNoticeDetail.setProjectStatus(s.getProjectStatus());
                        winBidNoticeDetail.setProjectDescript(s.getProjectDescript());
                        winBidNoticeDetail.setPersonLiableId(s.getPersonLiableId());
                        winBidNoticeDetail.setPersonLiableName(s.getPersonLiableName());
                        winBidNoticeDetail.setPersonLiablePhone(s.getPersonLiablePhone());
                        winBidNoticeDetail.setBond(s.getBond());

                        winBidNoticeDetailList.add(winBidNoticeDetail);
                    });
                }else {
                    //以供应商评标
                    //查询报价明细
                    QueryFilter<BizBiddingQuotation> quoQF = QueryFilter.build();
                    quoQF.addFilter("quo.NOTICE_ID_",notice.getId(),QueryOP.EQUAL);
                    quoQF.addFilter("quo.QUOTATION_ROUNDS_",notice.getQuotationRoundsNum(),QueryOP.EQUAL);
                    quoQF.addFilter("quo.QUOTATION_COMPANY_ID_",quoOrgId,QueryOP.EQUAL);
                    quoQF.setPageBean(new PageBean(0,-1,false));
                    List<BizBiddingQuotation> quoList = quotationManager.pageProDetail(quoQF).getRows();
                    BizBidEvaluation bidEvaluation = finalBidEvaList.stream().filter(s -> s.getQuotationOrgId().equals(quoOrgId)).collect(Collectors.toList()).get(0);
                    quoList.stream().forEach(s->{
                        BizWinBiddingNoticeDetaile winBidNoticeDetail = new BizWinBiddingNoticeDetaile();

                        if(BeanUtils.isNotEmpty(s.getTenderExplain())){
                            winBidNoticeDetail.setTenderExplain(s.getTenderExplain());
                        }

                        winBidNoticeDetail.setEvaluationId(bidEvaluation.getId());
                        winBidNoticeDetail.setWinNoticeId(winBidNotice.getId());
                        winBidNoticeDetail.setNoticeId(entity.getNoticeId());
                        winBidNoticeDetail.setNoticeCode(notice.getNoticeCode());
                        winBidNoticeDetail.setNoticeName(notice.getNoticeTitle());
                        winBidNoticeDetail.setNoticeDetailedId(s.getNoticeDetailedId());
                        winBidNoticeDetail.setMatId(s.getMatId());
                        winBidNoticeDetail.setMatPlatcode(s.getMatPlatcode());
                        winBidNoticeDetail.setMatCategoryCode(s.getMatCategoryCode());
                        winBidNoticeDetail.setMatCode(s.getMatCode());
                        winBidNoticeDetail.setMatName(s.getMatName());
                        winBidNoticeDetail.setMatMaterial(s.getMatMaterial());
                        winBidNoticeDetail.setMatSpec(s.getMatSpec());
                        winBidNoticeDetail.setMatNum(s.getMatNum());
                        winBidNoticeDetail.setMatUnit(s.getMatUnit());
                        winBidNoticeDetail.setDemandDate(s.getDemandDate());
                        winBidNoticeDetail.setMatBrand(s.getMatBrand());
                        winBidNoticeDetail.setMatBaseExt(s.getMatBaseExt());
                        winBidNoticeDetail.setMatOtherExt(s.getMatOtherExt());
                        winBidNoticeDetail.setTaxRate(s.getTaxRate());
                        winBidNoticeDetail.setStatus(2);
                        winBidNoticeDetail.setShareAllocationRate(bidEvaluation.getShareAllocationRate());
                        winBidNoticeDetail.setShareAllocationNum(winBidNoticeDetail.getShareAllocationRate().divide(new BigDecimal("100")).multiply(winBidNoticeDetail.getMatNum()));
                        winBidNoticeDetail.setWinBidPrice(s.getQuotationPrice());
                        winBidNoticeDetail.setWinBidAmount(s.getQuotationAmount());
                        winBidNoticeDetail.setPlanCode(s.getPlanCode());
                        winBidNoticeDetail.setIsTax(s.getIsTax());
                        if(BeanUtils.isNotEmpty(s.getAcceptanceTime())){
                            winBidNoticeDetail.setAcceptanceTime(s.getAcceptanceTime());
                        }
                        if(BeanUtils.isNotEmpty(s.getPendingTime())){
                            winBidNoticeDetail.setPendingTime(s.getPendingTime());
                        }
                        if(BeanUtils.isNotEmpty(s.getPurNote())){
                            winBidNoticeDetail.setPurNote(s.getPurNote());
                        }
                        if(BeanUtils.isNotEmpty(s.getUnloadAddress())){
                            winBidNoticeDetail.setUnloadAddress(s.getUnloadAddress());
                        }
                        winBidNoticeDetail.setApplicationId(s.getPurchasingApplicationId());
                        winBidNoticeDetail.setApplicationDetailId(s.getPurchasingApplicationDetailId());
                        winBidNoticeDetail.setQuotationMethod(notice.getQuotationMethod());

                        winBidNoticeDetail.setProjectSourceType(s.getProjectSourceType());
                        winBidNoticeDetail.setProjectInfoId(s.getProjectInfoId());
                        winBidNoticeDetail.setProjectLedgerId(s.getProjectLedgerId());
                        winBidNoticeDetail.setProjectLedgerCode(s.getProjectLedgerCode());
                        winBidNoticeDetail.setDetailType(s.getDetailType());
                        winBidNoticeDetail.setServiceStartTime(s.getServiceStartTime());
                        winBidNoticeDetail.setServiceEndTime(s.getServiceEndTime());
                        winBidNoticeDetail.setBuildingArea(s.getBuildingArea());
                        winBidNoticeDetail.setConstructionEngineering(s.getConstructionEngineering());
                        winBidNoticeDetail.setEquipmentProcurement(s.getEquipmentProcurement());
                        winBidNoticeDetail.setOtherExpenses(s.getOtherExpenses());
                        winBidNoticeDetail.setEquipmentClassification(s.getEquipmentClassification());
                        winBidNoticeDetail.setTechnicalRequirement(s.getTechnicalRequirement());
                        winBidNoticeDetail.setProjectStatus(s.getProjectStatus());
                        winBidNoticeDetail.setProjectDescript(s.getProjectDescript());
                        winBidNoticeDetail.setPersonLiableId(s.getPersonLiableId());
                        winBidNoticeDetail.setPersonLiableName(s.getPersonLiableName());
                        winBidNoticeDetail.setPersonLiablePhone(s.getPersonLiablePhone());
                        winBidNoticeDetail.setBond(s.getBond());

                        winBidNoticeDetailList.add(winBidNoticeDetail);
                    });
                }

            });

            if(winBidNoticeDetailList.size()>0){
                winBidNoticeDetaileManager.saveBatch(winBidNoticeDetailList);
            }
        }

        if(BeanUtils.isNotEmpty(notice.getBond()) && notice.getBond().compareTo(BigDecimal.ZERO)>0){
            //查询参与表 该立项已参与且未中标的供应商
            LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
            userParticipationQW.eq(UserParticipation::getNoticeId,notice.getId())
                    .notIn(winOrgId.size()>0,UserParticipation::getCompanyId,winOrgId)
                    .eq(UserParticipation::getStatus,1)
                    .gt(UserParticipation::getPrice,0)
                    .eq(UserParticipation::getType,1)
                    .eq(UserParticipation::getIsDele,"0");
            List<UserParticipation> userParticipationList = userParticipationManager.list(userParticipationQW);
            if(BeanUtils.isNotEmpty(userParticipationList) && userParticipationList.size()>0){
                //退还保证金
                for(UserParticipation userPart : userParticipationList){
                    if(BeanUtils.isEmpty(userPart.getRegistrationOrderId())){
                        continue;
                    }
                    //1.查询保证金支付记录
                    BizRegistrationOrder regisOrder = registrationOrderManager.getById(userPart.getRegistrationOrderId());
                    //2.生成退还保证金记录
                    BizRegistrationOrder refundRegisOrder = new BizRegistrationOrder();
                    refundRegisOrder.setParticipationId(userPart.getId());
                    String orderNumber = BizUtils.getNextSerialNumber(systemConfigFeignService, "zfjl_ddh");
                    refundRegisOrder.setOrderNumber(orderNumber);
                    refundRegisOrder.setPayStatus(3);
                    refundRegisOrder.setRefundStatus(1);
                    refundRegisOrder.setNoticeId(notice.getId());
                    refundRegisOrder.setNoticeType(2);
                    IUser user = ContextUtil.getCurrentUser();
                    refundRegisOrder.setUserId(user.getUserId());
                    refundRegisOrder.setUserAccount(user.getAccount());
                    refundRegisOrder.setUserName(user.getFullname());
                    if(BeanUtils.isNotEmpty(user.getMobile())) {
                        refundRegisOrder.setUserPhone(user.getMobile());
                    }
                    refundRegisOrder.setPayType(6);
                    Org payOrg = orgManager.getByCode("00001513");
                    if(BeanUtils.isEmpty(payOrg)){
                        throw new BaseException("未找到编号为【00001513】企业信息，请联系相关人员注册");
                    }
                    refundRegisOrder.setPayUnitId(regisOrder.getCollectUnitId());
                    refundRegisOrder.setPayUnitCode(regisOrder.getCollectUnitCode());
                    refundRegisOrder.setPayUnitName(regisOrder.getCollectUnitName());
                    refundRegisOrder.setPayAccount(regisOrder.getCollectAccount());
                    refundRegisOrder.setPayAccountBank(regisOrder.getCollectAccountBank());
                    refundRegisOrder.setPayTime(LocalDateTime.now());
                    refundRegisOrder.setPayTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
                    refundRegisOrder.setPayAmount(regisOrder.getPayAmount());
                    refundRegisOrder.setCollectUnitId(regisOrder.getPayUnitId());
                    refundRegisOrder.setCollectUnitCode(regisOrder.getPayUnitCode());
                    refundRegisOrder.setCollectUnitName(regisOrder.getPayUnitName());
                    refundRegisOrder.setCollectAccount(regisOrder.getPayAccount());
                    refundRegisOrder.setCollectAccountBank(regisOrder.getPayAccountBank());
                    refundRegisOrder.setCollectTime(regisOrder.getPayTime());
                    refundRegisOrder.setCollectTimer(regisOrder.getPayTimer());
                    refundRegisOrder.setPayDescribe("退还保证金");
                    registrationOrderManager.save(refundRegisOrder);
                    List<BizRegistrationOrderDetails> detailedList = new ArrayList<>();
                    ForeignResponseVo res = null;

                    //保证金
                    TransVo transVo = new TransVo();
                    try {
                        BeanUtils.copyNotNullProperties(transVo,refundRegisOrder);
                    } catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        throw new BaseException(e.getMessage());
                    }
                    transVo.setStatementsCode(refundRegisOrder.getOrderNumber());
                    transVo.setDepositPaymentStatus(refundRegisOrder.getPayStatus());

                    BizRegistrationOrderDetails detail = new BizRegistrationOrderDetails();
                    detail.setRegistrationOrderId(refundRegisOrder.getId());
                    detail.setRegistrationOrderNumber(refundRegisOrder.getOrderNumber());

                    detail.setUserId(refundRegisOrder.getUserId());
                    detail.setUserName(refundRegisOrder.getUserName());
                    detail.setUserAccount(refundRegisOrder.getUserAccount());
                    if(BeanUtils.isNotEmpty(refundRegisOrder.getUserPhone())) {
                        detail.setUserPhone(refundRegisOrder.getUserPhone());
                    }
                    detail.setCompanyId(refundRegisOrder.getPayUnitId());
                    detail.setCompanyCode(refundRegisOrder.getPayUnitCode());
                    detail.setCompanyName(refundRegisOrder.getPayUnitName());
                    detail.setNoticeId(refundRegisOrder.getNoticeId());
                    detail.setNoticeType(refundRegisOrder.getNoticeType());
                    detail.setNoticeTitle(notice.getNoticeTitle());
                    detail.setPayName(notice.getNoticeTitle());
                    detail.setRechargeNumber(BigDecimal.ONE);
                    detail.setRechargePrice(refundRegisOrder.getPayAmount());
                    detail.setSalesCompanyId(refundRegisOrder.getCollectUnitId());
                    detail.setSalesCompanyCode(refundRegisOrder.getCollectUnitCode());
                    detail.setSalesCompanyName(refundRegisOrder.getCollectUnitName());
                    detailedList.add(detail);

                    List<OrderDetailsVo> orderDetailsList = new ArrayList<>();
                    OrderDetailsVo orderDetailsVo = new OrderDetailsVo();
                    try {
                        BeanUtils.copyNotNullProperties(orderDetailsVo,detail);
                    } catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        System.out.println("订单明细转换错误："+e.getMessage());
                        throw new BaseException("订单明细转换错误："+e.getMessage());
                    }
                    orderDetailsVo.setPayType(6);
                    orderDetailsList.add(orderDetailsVo);
                    transVo.setOrderDetails(orderDetailsList);

                    //3.调用支付平台内部支付接口
                    res = foreignCallService.callPay(transVo, 1);

                    if(BeanUtil.isEmpty(res)) {
                        throw new BaseException("调用[支付平台]支付失败");
                    }
                    if(!res.getCode().equals("0")) {
                        throw new BaseException("调用[支付平台]支付失败:"+ res.getMsg());
                    }

                    if(detailedList.size()>0){
                        registrationOrderDetailsManager.saveBatch(detailedList);
                    }

                    regisOrder.setRefundStatus(3);
                    regisOrder.setRefundOrderId(refundRegisOrder.getId());
                    registrationOrderManager.updateById(regisOrder);
                    //设置退款id
                    userPart.setRefundRegistrationOrderId(refundRegisOrder.getId());
                    userPart.setRefundRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
                }
                userParticipationManager.updateBatchById(userParticipationList);
            }

        }

    }

    @Override
    public PageList<BizWinBiddingNotice> getWinBidVendor(QueryFilter<BizWinBiddingNotice> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", 0, QueryOP.EQUAL);

        //查询当前企业为采购企业，或可共享的项目


        IPage<BizWinBiddingNotice> result = baseMapper.getWinBidVendor(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

}
