package com.artfess.cgpt.winbind.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticePublicity;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticePublicityManager;

import java.util.List;

/**
 * 中标公示记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */

@RestController
@RequestMapping("/bizWinBiddingNoticePublicity/v1/")
@Api(tags = "中标公示记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizWinBiddingNoticePublicityController extends BaseController<BizWinBiddingNoticePublicityManager, BizWinBiddingNoticePublicity> {
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizWinBiddingNoticePublicity>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizWinBiddingNoticePublicity> queryFilter){

        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);
        PageList<BizWinBiddingNoticePublicity> result=baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizWinBiddingNoticePublicity> selectOne(@RequestParam String id){
        BizWinBiddingNoticePublicity result=baseService.get(id);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody BizWinBiddingNoticePublicity publicity) {
        String message = "操作成功";
        baseService.saveOrUpdate(publicity);
        return new CommonResult<>(true, message);
    }

}
