package com.artfess.cgpt.violate.manager.impl;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.violate.dao.BizViolateRecordDao;
import com.artfess.cgpt.violate.manager.BizViolateRecordDetailManager;
import com.artfess.cgpt.violate.manager.BizViolateRecordManager;
import com.artfess.cgpt.violate.model.BizViolateRecord;
import com.artfess.cgpt.violate.model.BizViolateRecordDetail;
import com.artfess.cgpt.violate.vo.ViolateRecordVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 竞价违约记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizViolateRecordManagerImpl extends BaseManagerImpl<BizViolateRecordDao, BizViolateRecord> implements BizViolateRecordManager {


    @Autowired
    private BizViolateRecordDetailManager recordDetailManager;
    @Autowired
    private MatApprovalDetailsManager matApprovalDetailsManager;

    @Override
    public ViolateRecordVo getDetail(String id) {
        BizViolateRecord record = this.get(id);
        ViolateRecordVo recordVo = new ViolateRecordVo();
        recordVo.setViolateRecord(record);
        List<BizViolateRecordDetail> detailList= recordDetailManager.getByPid(id);
        recordVo.setRecordDetails(detailList);
        return recordVo;
    }


    /**
     *
     * @param recordVo
     */
    @Override
    public void refuse(ViolateRecordVo recordVo) {
        BizViolateRecord record = recordVo.getViolateRecord();
        this.save(record);
        List<BizViolateRecordDetail> details = recordVo.getRecordDetails();
        for (BizViolateRecordDetail detail : details) {
            detail.setVrId(record.getId());
        }
        recordDetailManager.saveBatch(details);
    }

    @Override
    @Transactional
    public void updateHandleStatus(String id, Integer status,Integer type) {
        IUser currentUser = ContextUtil.getCurrentUser();

        //更新处理状态
        LambdaUpdateWrapper<BizViolateRecord> violateRecordUW = new LambdaUpdateWrapper<>();
        violateRecordUW.set(BizViolateRecord::getHandleStatus,status)
                .set(BizViolateRecord::getHandleUserId,currentUser.getUserId())
                .set(BizViolateRecord::getHandleUserAccount,currentUser.getAccount())
                .set(BizViolateRecord::getHandleUserName,currentUser.getFullname())
                .set(BizViolateRecord::getHandleTime,LocalDateTime.now())
                .eq(BizViolateRecord::getId,id)
                .eq(BizViolateRecord::getIsDele,"0");
        super.update(violateRecordUW);

        if(status==3){
            //如果状态为流标，查询违约明细
            LambdaQueryWrapper<BizViolateRecordDetail> recordDetailQW = new LambdaQueryWrapper<>();
            recordDetailQW.eq(BizViolateRecordDetail::getVrId,id);
            List<BizViolateRecordDetail> recordDetailList = recordDetailManager.list(recordDetailQW);

            if(BeanUtils.isNotEmpty(recordDetailList) && recordDetailList.size()>0){
                //更新立项明细状态为流标
                List<String> noticeDetails = recordDetailList.stream().map(s -> s.getNoticeDetailId()).collect(Collectors.toList());

                if(type==1){
                    LambdaUpdateWrapper<MatApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
                    noticeDetailUW.set(MatApprovalDetails::getBidStatus,6)
                            .in(MatApprovalDetails::getId,noticeDetails)
                            .eq(MatApprovalDetails::getIsDele,"0");
                    matApprovalDetailsManager.update(noticeDetailUW);
                }

            }

        }




    }

}
