package com.artfess.cgpt.utils;

import com.artfess.sysConfig.persistence.param.DictModel;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;

import java.util.List;

public class BizUtil {

    /**
     * 根据字典值获取字典文本
     *
     * @param dic  字典集合
     * @param code 值
     * @return 文本
     */
    public static String getDicValueByCode(List<DictModel> dic, String code) {
        if (dic.size()<=0) {
            return "";
        }
        for (DictModel ele : dic) {
            if (ele.getValue().equals(code)) {
                return ele.getName();
            }
        }
        return "";
    }

    /**
     * 设置EasyPOI导出参数
     *
     * @param fileName 文件名
     * @return 导出参数
     */
    public static ExportParams getExportParams(String fileName) {
        ExportParams exportParams = new ExportParams(null, fileName);
        exportParams.setStyle(EasyPoiStyle.class);
        exportParams.setType(ExcelType.XSSF);
        return exportParams;
    }
}
