package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @Description:供应商问题问答记录表
 * @Author: Rong Tao
 * @Date: 2024/7/4 10:41
 */
@ApiModel(value="SupplierIssueManagementDetail对象", description="供应商问题问答记录表")
@TableName("biz_supplier_issue_management_detail")
@Data
public class SupplierIssueManagementDetail extends BizNoModel<SupplierIssueManagementDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商问题管理表ID")
    @TableField("ISSUE_ID_")
    private String issueId;

    @ApiModelProperty(value = "组织ID（关联组织表ID）")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "组织编码")
    @TableField("ORG_CODE_")
    private String orgCode;

    @ApiModelProperty(value = "组织名称")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "操作人ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "操作人名称")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "联系电话")
    @TableField("CONTACT_PHONE_")
    private String contactPhone;

    @ApiModelProperty(value = "联系地址")
    @TableField("CONTACT_ADDRESS_")
    private String contactAddress;

    @ApiModelProperty(value = "操作类型（1.提问，2.回答）")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "描述（问答内容）")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "记录时间")
    @TableField("RECORD_TIME_")
    private LocalDateTime recordTime;

}
