package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizNoModel;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.purchasing.model.*;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:数据共享管理明细
 * @Author: Rong Tao
 * @Date: 2024/8/6 19:33
 */
@ApiModel(value="DataSharingDetail对象", description="数据共享管理明细")
@TableName("biz_data_sharing_detail")
@Data
public class DataSharingDetail extends BizNoModel<DataSharingDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据共享管理表ID")
    @TableField("DATA_SHARING_ID_")
    private String dataSharingId;

    @ApiModelProperty(value = "共享公告编码")
    @TableField("SHARING_NOTICE_CODE_")
    private String sharingNoticeCode;

    @ApiModelProperty(value = "共享公告ID")
    @TableField("SHARING_NOTICE_ID_")
    private String sharingNoticeId;



    @ApiModelProperty(value = "项目标题")
    @TableField(exist = false)
    private String noticeTitle;

    @ApiModelProperty(value = "是否集中采购（0：自采，1：集采）")
    @TableField(exist = false)
    private Integer matIfPlat;

    @ApiModelProperty(value = "组织公司ID")
    @TableField(exist = false)
    private String affiliatedOrgId;

    @ApiModelProperty(value = "组织公司编码")
    @TableField(exist = false)
    private String affiliatedOrgCode;

    @ApiModelProperty(value = "组织公司名称")
    @TableField(exist = false)
    private String affiliatedOrgName;

    @ApiModelProperty(value = "采购公司ID")
    @TableField(exist = false)
    private String procureOrgId;

    @ApiModelProperty(value = "采购公司编码")
    @TableField(exist = false)
    private String procureOrgCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField(exist = false)
    private String procureOrgName;

    @ApiModelProperty(value = "发布方式（1.公开，2.邀请）")
    @TableField(exist = false)
    private Integer releaseMethod;

    @ApiModelProperty(value = "采购类型（1：公开招标，2：询比价，3：限时竞价，" +
            "4：份额采购（谈判），5：单一来源，6：比选（多轮竞价），7：公开邀请）")
    @TableField(exist = false)
    private Integer procureType;

    @ApiModelProperty(value = "公告发布时间")
    @TableField(exist = false)
    private LocalDateTime noticeReleaseTime;

    @ApiModelProperty(value = "项目类型（1：标准采购申请，2：固定单价申请，3：其他），引用采购申请")
    @TableField(exist = false)
    private Integer applicationType;

    @ApiModelProperty(value = "项目状态（2：已立项，3：已发布，4：未开标，"+
            "5：已开标，6：已评标，7：已中标，8：流标，9：已发布成交公示，10：定标，11：已发布成交通知）")
    @TableField(exist = false)
    private Integer bidStatus;

    @ApiModelProperty(value = "是否重复生成合同（0.否，1.是）")
    @TableField(exist = false)
    private Integer generateDuplicateContracts;

    @ApiModelProperty(value = "中标结果有效期（天）")
    @TableField(exist = false)
    private Integer winBidValidity;

    @ApiModelProperty(value = "是否代采（0.否，1.是），默认0")
    @TableField(exist = false)
    private Integer isAgencyProcure;

}
