package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/6 19:24
 */
@ApiModel(value="DataSharing对象", description="数据共享管理")
@TableName("biz_data_sharing")
@Data
public class DataSharing extends BizModel<DataSharing> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "组织ID")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "组织编码")
    @TableField("ORG_CODE_")
    private String orgCode;

    @ApiModelProperty(value = "组织名称")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "共享组织ID")
    @TableField("SHARING_ORG_ID_")
    private String sharingOrgId;

    @ApiModelProperty(value = "共享组织编码")
    @TableField("SHARING_ORG_CODE_")
    private String sharingOrgCode;

    @ApiModelProperty(value = "共享组织名称")
    @TableField("SHARING_ORG_NAME_")
    private String sharingOrgName;

    @ApiModelProperty(value = "共享菜单别名")
    @TableField("SHARING_MENU_ALIAS_")
    private String sharingMenuAlias;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "明细集合")
    @TableField(exist = false)
    private List<DataSharingDetail> detailList;

}
