package com.artfess.cgpt.supplier.model;

import java.math.BigDecimal;

import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-03
 */
@ApiModel(value="BizSupplierOrg对象", description="供应商表")
@Data
public class BizSupplierOrg extends BaseModel<BizSupplierOrg> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商编号")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "公司名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "供应商类型ID（关联供应商分类表ID）")
    @TableField("SUPPLIER_TYPE_ID_")
    private String supplierTypeId;

    @ApiModelProperty(value = "供应商性质")
    @TableField("SUPPLIER_NATURE_")
    private String supplierNature;

    @ApiModelProperty(value = "公司简称")
    @TableField("SUPPLIER_SHORT_NAME_")
    private String supplierShortName;

    @ApiModelProperty(value = "公司网址")
    @TableField("SUPPLIER_WWW_")
    private String supplierWww;

    @ApiModelProperty(value = "联系人姓名")
    @TableField("SUPPLIER_CONTACT_NAME_")
    private String supplierContactName;

    @ApiModelProperty(value = "固定电话")
    @TableField("SUPPLIER_PHONE_")
    private String supplierPhone;

    @ApiModelProperty(value = "移动电话")
    @TableField("SUPPLIER_MOBILE_")
    private String supplierMobile;

    @ApiModelProperty(value = "电子邮箱")
    @TableField("SUPPLIER_EMIL_")
    private String supplierEmil;

    @ApiModelProperty(value = "传真")
    @TableField("SUPPLIER_FAX_")
    private String supplierFax;

    @ApiModelProperty(value = "邮编")
    @TableField("SUPPLIER_POSTAL_CODE_")
    private String supplierPostalCode;

    @ApiModelProperty(value = "邮寄地址")
    @TableField("SUPPLIER_POSTAL_ADDRESS_")
    private String supplierPostalAddress;

    @ApiModelProperty(value = "法定代表人姓名")
    @TableField("LEGAL_PERSON_")
    private String legalPerson;

    @ApiModelProperty(value = "成立日期")
    @TableField("ESTABLISHMENT_DATE_")
    private LocalDate establishmentDate;

    @ApiModelProperty(value = "所属行业（使用字典，1：农、林、牧、渔业，2：采矿业，3：制造业，4：电力、热力、燃气及水生产和供应业，5：建筑业，6：批发和零售业，7：交通运输、仓储和邮政业，8：住宿和餐饮业，9：信息传输、软件和信息技术服务业，10：金融业，11：房地产业，12：租赁和商务服务业，13：科学研究和技术服务业，14：水利、环境和公共设施管理业，15：居民服务、修理和其他服务业，16：教育，17：卫生和社会工作，18：文化、体育和娱乐业，19：公共管理、社会保障和社会组织，20：国际组织）")
    @TableField("INDUSTRY_")
    private String industry;

    @ApiModelProperty(value = "人数规模")
    @TableField("PEOPLE_NUMBER_SCALE_")
    private String peopleNumberScale;

    @ApiModelProperty(value = "工商注册号")
    @TableField("BUSINESS_REGISTRATION_NUMBER_")
    private String businessRegistrationNumber;

    @ApiModelProperty(value = "公司类型（使用字典：110：国有企业，120：集团企业，130：股份合作企业，141：联营企业，150：有限责任公司，160：股份有限公司，170：私营企业，190：其他企业，200：港澳台商投资企业，300：外商投资企业，810：军队单位）")
    @TableField("COMPANY_TYPE_")
    private String companyType;

    @ApiModelProperty(value = "税务登记号(国税)")
    @TableField("NATIONAL_TAX_")
    private String nationalTax;

    @ApiModelProperty(value = "税务登记号(地税)")
    @TableField("LOCAL_TAX_")
    private String localTax;

    @ApiModelProperty(value = "注册资本(万元)")
    @TableField("REGISTERED_CAPITAL_")
    private BigDecimal registeredCapital;

    @ApiModelProperty(value = "注册资本币种（使用字典：1人民币，2：美元，3：日元，4：欧元，5：港币）")
    @TableField("REGISTERED_CAPITAL_CURRENCY_")
    private String registeredCapitalCurrency;

    @ApiModelProperty(value = "注册资本大写")
    @TableField("REGISTERED_CAPITAL_CURRENCY_CAPITALIZATION_")
    private String registeredCapitalCurrencyCapitalization;

    @ApiModelProperty(value = "组织机构代码")
    @TableField("ORGANIZATION_CODE_")
    private String organizationCode;

    @ApiModelProperty(value = "国家（使用字典，1：中国，2：美国，3：日本）")
    @TableField("COUNTRY_")
    private String country;

    @ApiModelProperty(value = "所属行政区划_ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_")
    private String sysAreasId;

    @ApiModelProperty(value = "所属行政区划_NAME（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_")
    private String sysAreasName;

    @ApiModelProperty(value = "所属行政区划_全路径ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_PATH_")
    private String sysAreasIdPath;

    @ApiModelProperty(value = "属行政区划_全路径名称（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_PATH_")
    private String sysAreasNamePath;

    @ApiModelProperty(value = "住所")
    @TableField("RESIDENCE_")
    private String residence;

    @ApiModelProperty(value = "纳税人身份")
    @TableField("TAXPAYER_IDENTITY_")
    private String taxpayerIdentity;

    @ApiModelProperty(value = "增值税税率")
    @TableField("VALUE_ADDED_TAX_RATE_")
    private BigDecimal valueAddedTaxRate;

    @ApiModelProperty(value = "银行助记码")
    @TableField("BANK_MNEMONIC_CODE_")
    private String bankMnemonicCode;

    @ApiModelProperty(value = "开户行")
    @TableField("BANK_")
    private String bank;

    @ApiModelProperty(value = "银行账号")
    @TableField("BANK_NUMBER_")
    private String bankNumber;

    @ApiModelProperty(value = "银行信用登记")
    @TableField("BANK_CREDIT_REGISTRATION")
    private String bankCreditRegistration;

    @ApiModelProperty(value = "付款方式")
    @TableField("PAYMENT_METHOD_")
    private String paymentMethod;

    @ApiModelProperty(value = "财务经营状态")
    @TableField("FINANCIAL_OPERATION_STATUS_")
    private String financialOperationStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @JsonIgnore
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "供应商分类集合")
    @TableField(exist = false)
    private List<BizSupplierType> supplierTypeList;

    @ApiModelProperty(value = "供应商资质集合")
    @TableField(exist = false)
    private List<BizQualificationLabel> qualificationLabelList;


}
