package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 送货地址管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wsf
 * @since 2024-06-21
 */
@Data
@ApiModel(value="BizDeliveryAddress对象", description="送货地址管理表")
@TableName("biz_delivery_address")
public class BizDeliveryAddress extends BizModel<BizDeliveryAddress> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "编号（自动生成）")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "企业ID（关联组织表ID）")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "企业联系人")
    @TableField("ENTERPRISE_CONTACT_")
    private String enterpriseContact;

    @ApiModelProperty(value = "企业联系电话")
    @TableField("ENTERPRISE_CONTACT_PHONE_")
    private String enterpriseContactPhone;

    @ApiModelProperty(value = "送货地址")
    @TableField("ENTERPRISE_CONTACT_ADDRESS_")
    private String enterpriseContactAddress;

    @ApiModelProperty(value = "是否默认（1：是，0：否），默认0")
    @TableField("DEFAULT_STATUS_")
    private Integer defaultStatus;

    @ApiModelProperty(value = "启用状态（1：启用，0：禁用），默认1")
    @TableField("ENABLING_STATUS_")
    private Integer enablingStatus;

}
