package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.supplier.dao.DataSharingDetailDao;
import com.artfess.cgpt.supplier.manager.DataSharingDetailManager;
import com.artfess.cgpt.supplier.model.DataSharingDetail;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/6 19:37
 */
@Service
public class DataSharingDetailManagerImpl extends BaseManagerImpl<DataSharingDetailDao, DataSharingDetail> implements DataSharingDetailManager {

    @Override
    public PageList<DataSharingDetail> queryByPage(QueryFilter<DataSharingDetail> queryFilter) {
        IPage<DataSharingDetail> result = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<DataSharingDetail> queryAllByPage(QueryFilter<DataSharingDetail> queryFilter) {
        queryFilter.addFilter("b.IS_DELE_","0", QueryOP.EQUAL);
        IPage<DataSharingDetail> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
