package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.artfess.cgpt.supplier.dao.BizSupplierOrgQualificationLabelDao;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgQualificationLabelManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 供应商资质信息表，供应商_资质库中间表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizSupplierOrgQualificationLabelManagerImpl extends BaseManagerImpl<BizSupplierOrgQualificationLabelDao, BizSupplierOrgQualificationLabel> implements BizSupplierOrgQualificationLabelManager {

    @Override
    public PageList<BizSupplierOrgQualificationLabel> queryByPage(QueryFilter<BizSupplierOrgQualificationLabel> queryFilter) {
        IPage<BizSupplierOrgQualificationLabel> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<BizQualificationLabel> queryQualificationPage(QueryFilter<BizSupplierOrgQualificationLabel> queryFilter) {
        IPage<BizQualificationLabel> result = baseMapper.queryQualificationPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
