package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.dao.BizSupplierOrgDao;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.supplier.model.BizSupplierOrgSupplierType;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 供应商表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizSupplierOrgManagerImpl extends BaseManagerImpl<BizSupplierOrgDao, BizSupplierOrg> implements BizSupplierOrgManager {

    @Override
    public PageList<BizSupplierOrg> queryAllByPage(QueryFilter<BizSupplierOrg> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizSupplierOrg> Ipage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(Ipage);
    }

    @Override
    public List<BizSupplierType> querySupplierType(String supplierId) {
        List<BizSupplierType> list= baseMapper.querySupplierType(supplierId);
        return list;
    }

    @Override
    public List<BizQualificationLabel> queryQualification(String supplierId) {
        List<BizQualificationLabel> list= baseMapper.queryQualification(supplierId);
        return list;
    }
}
