package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.model.BizSupplierOrgBlacklist;
import com.artfess.cgpt.supplier.dao.BizSupplierOrgBlacklistDao;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgBlacklistManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 供应商黑名单，本表有附件 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizSupplierOrgBlacklistManagerImpl extends BaseManagerImpl<BizSupplierOrgBlacklistDao, BizSupplierOrgBlacklist> implements BizSupplierOrgBlacklistManager {

    @Autowired
    private AccessoryService accessoryService;

    @Override
    public PageList<BizSupplierOrgBlacklist> queryAllByPage(QueryFilter<BizSupplierOrgBlacklist> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);
        IPage<BizSupplierOrgBlacklist> Ipage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(Ipage);
    }

    @Override
    public void saveOrUpdateEntity(BizSupplierOrgBlacklist entity) {

        super.saveOrUpdate(entity);
        List<Accessory> accessoryList = entity.getAccessoryList();

        if (BeanUtils.isNotEmpty(entity.getId())) {
            //更新，删除然后重新添加附件
            LambdaQueryWrapper<Accessory> accessoryQueryWrapper = new LambdaQueryWrapper<>();
            accessoryQueryWrapper.eq(Accessory::getSourceId, entity.getId());
            accessoryService.remove(accessoryQueryWrapper);
        }

        if (BeanUtils.isNotEmpty(accessoryList)) {
            accessoryList.stream().forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }
    }

    @Override
    public BizSupplierOrgBlacklist getDataById(String id) {
        BizSupplierOrgBlacklist result = super.getById(id);
        // 查询附件信息
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(result.getId()));
        return result;
    }

}
