package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.manager.DataSharingDetailManager;
import com.artfess.cgpt.supplier.model.DataSharing;
import com.artfess.cgpt.supplier.model.DataSharingDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:数据共享管理明细
 * @Author: Rong Tao
 * @Date: 2024/8/6 19:38
 */
@RestController
@RequestMapping("/dataSharingDetail/v1/")
@Api(tags="数据共享管理明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class DataSharingDetailController extends BaseController<DataSharingDetailManager,DataSharingDetail> {

    @PostMapping(value="/queryAll")
    @ApiOperation("M-分页查询所有数据")
    public CommonResult queryAll(@RequestBody QueryFilter<DataSharingDetail> queryFilter) {
        PageList<DataSharingDetail> result = baseService.queryByPage(queryFilter);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping(value="/queryAllByPage")
    @ApiOperation("M-分页查询所有数据（带公告信息）")
    public CommonResult queryAllByPage(@RequestBody QueryFilter<DataSharingDetail> queryFilter) {
        PageList<DataSharingDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult(true,"查询成功",result);
    }

}
