package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.manager.AdmittedSuppliersQualificationManager;
import com.artfess.cgpt.supplier.model.AdmittedSuppliersQualification;
import com.artfess.cgpt.supplier.model.BizSupplierOrgBlacklist;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:准入供应商资质关联表
 * @Author: Rong Tao
 * @Date: 2024/6/19 16:21
 */
@RestController
@RequestMapping("/admittedSuppliersQualification/v1/")
@Api(tags="准入供应商资质关联表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class AdmittedSuppliersQualificationController extends BaseController<AdmittedSuppliersQualificationManager, AdmittedSuppliersQualification> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<AdmittedSuppliersQualification>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<AdmittedSuppliersQualification> queryFilter){
        PageList<AdmittedSuppliersQualification> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

}
