package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.manager.AdmissionConfigQualificationManager;
import com.artfess.cgpt.supplier.model.AdmissionConfig;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import com.artfess.cgpt.utils.BizUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:准入配置资质要求关联表
 * @Author: Rong Tao
 * @Date: 2024/7/11 11:10
 */
@RestController
@RequestMapping("/admissionConfigQualification/v1/")
@Api(tags="准入配置资质要求关联表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class AdmissionConfigQualificationController extends BaseController<AdmissionConfigQualificationManager,AdmissionConfigQualification> {

    @PostMapping(value="/queryByPage")
    @ApiOperation("分页查询数据")
    public PageList<AdmissionConfigQualification> queryByPage(@RequestBody QueryFilter<AdmissionConfigQualification> queryFilter) {
        return baseService.queryByPage(queryFilter);
    }

}
