package com.artfess.cgpt.redisConfig;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.redis.util.RedisUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: redis监听类
 * @Author: Rong Tao
 * @Date: 2022/12/26 16:43
 */

@Component
public class RedisKeyExpiredListener extends KeyExpirationEventMessageListener {

    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private MatApprovalManager matApprovalManager;


    public RedisKeyExpiredListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    @Override
    @Transactional
    public void onMessage(Message message, byte[] pattern) {
        //类型，1：物资立项，2：项目立项
        Integer type = 0;
        System.out.println("------redis键过期调用------");
        //过期的key
        String key = new String(message.getBody(), StandardCharsets.UTF_8);
        if(key.contains("matApproval:")) {
            type = 1;
        }else if(key.contains("scpt:")) {
            type = 2;
        }

        String bizId = "";

        if(type==1){
            bizId = key.substring(key.indexOf("matApproval:")+6);
            System.out.println("----------------截取后的数据id"+bizId);

            MatApproval data = matApprovalManager.getById(bizId);
            if(BeanUtils.isEmpty(data)){
                return;
            }

            //2.查询参与报名供应商数量是否满足条件


            //3.不满足条件，自动采取流标操作
        }


    }

}
