package com.artfess.cgpt.receipt.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Description:采购发货明细表
 * @Author: Rong Tao
 * @Date: 2024/8/19 20:23
 */
@ApiModel(value="ArrivalDetail对象", description="采购发货明细表")
@TableName("biz_arrival_detail")
@Data
public class ArrivalDetail extends BizNoModel<ArrivalDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "发货单ID")
    @TableField("ARRIVAL_ID_")
    private String arrivalId;

    @ApiModelProperty(value = "采购订单ID")
    @TableField("PURCHASE_ORDER_ID_")
    private String purchaseOrderId;

    @ApiModelProperty(value = "采购订单号")
    @TableField("PURCHASE_ORDER_CODE_")
    private String purchaseOrderCode;

    @ApiModelProperty(value = "采购订单明细ID")
    @TableField("PURCHASE_ORDER_DETAIL_ID_")
    private String purchaseOrderDetailId;

    @ApiModelProperty(value = "关联合同表合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "合同明细ID，关联合同明细ID")
    @TableField("CONTRACT_ITEM_ID_")
    private String contractItemId;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项明细ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "发货人ID")
    @TableField("VENDOR_USER_ID_")
    private String vendorUserId;

    @ApiModelProperty(value = "发货人姓名")
    @TableField("VENDOR_USER_NAME_")
    private String vendorUserName;

    @ApiModelProperty(value = "发货人联系方式")
    @TableField("VENDOR_PHONE_")
    private String vendorPhone;

    @ApiModelProperty(value = "发货时间")
    @TableField("ARRIVAL_DATE_")
    private LocalDateTime arrivalDate;

    @ApiModelProperty(value = "收货地址")
    @TableField("UNLOAD_ADDRESS_")
    private String unloadAddress;

    @ApiModelProperty(value = "发货数量")
    @TableField("ARRIVAL_NUM_")
    private BigDecimal arrivalNum;

    @ApiModelProperty(value = "收货状态（1：未收货 ，2：已收货）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "物料ID（关联企业物料表id）")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业物料编号")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "物料分类")
    @TableField("MAT_CATEGORY_")
    private String matCategory;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "税额")
    @TableField("TAX_VALUE_")
    private BigDecimal taxValue;

    @ApiModelProperty(value = "税率（百分比）")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "不含税单价")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "不含税金额")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "含税单价")
    @TableField("TAX_INPRICE_")
    private BigDecimal taxInprice;

    @ApiModelProperty(value = "含税金额")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "供应商补充说明")
    @TableField("VENDOR_NOTE_")
    private String vendorNote;

    @ApiModelProperty(value = "交货期")
    @TableField("REQ_DATE_")
    private LocalDate reqDate;

    @ApiModelProperty(value = "企业补充说明")
    @TableField("PUR_NOTE_")
    private String purNote;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    private String planCode;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
