package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrder;
import com.artfess.cgpt.receipt.manager.*;
import com.artfess.cgpt.receipt.model.*;
import com.artfess.cgpt.receipt.vo.ReceiptVo;
import com.artfess.cgpt.receipt.dao.BizReceiptDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 采购收货单表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizReceiptManagerImpl extends BaseManagerImpl<BizReceiptDao, BizReceipt> implements BizReceiptManager {

    @Resource
    private BizReceiptDetailManager receiptDetailManager;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    BizReceiptHandleManager bizReceiptHandleManager;
    @Autowired
    BaseContext baseContext;
    @Autowired
    UserManager userManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ArrivalManager arrivalManager;
    @Autowired
    private ArrivalDetailManager arrivalDetailManager;

    @Override
    public BizReceipt getDetailById(String id) {
        BizReceipt result = super.getById(id);
        List<BizReceiptDetail> detailList  =receiptDetailManager.getByReceiptId(id);
        result.setDetailList(detailList);
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    @Transactional
    public String saveVo(BizReceipt entity) {
        List<BizReceiptDetail> detailList = entity.getDetailList();
        List<Accessory> accessoryList = entity.getAccessoryList();

        if(BeanUtils.isEmpty(entity.getId())){
            //新增
            if(BeanUtils.isEmpty(entity.getReceiptCode())){
                entity.setReceiptCode(BizUtils.getNextSerialNumber(systemConfigFeignService, "cgpt_cgsh"));
            }
            entity.setStatus(1);
        }else {
            //更新
            List<BizReceiptDetail> receiptDetails = receiptDetailManager.getByReceiptId(entity.getId());
            if(BeanUtils.isNotEmpty(receiptDetails) && receiptDetails.size()>0){
                List<String> collect = receiptDetails.stream().map(s -> s.getArrivalId()).distinct().collect(Collectors.toList());
                List<String> collect1 = receiptDetails.stream().map(s -> s.getArrivalDetailId()).distinct().collect(Collectors.toList());

                LambdaUpdateWrapper<Arrival> arrivalUW = new LambdaUpdateWrapper<>();
                arrivalUW.set(Arrival::getStatus,2)
                        .in(Arrival::getId,collect)
                        .eq(Arrival::getIsDele,"0");
                arrivalManager.update(arrivalUW);

                LambdaUpdateWrapper<ArrivalDetail> arrivalDetailUW = new LambdaUpdateWrapper<>();
                arrivalDetailUW.set(ArrivalDetail::getStatus,1)
                        .in(ArrivalDetail::getId,collect1);
                arrivalDetailManager.update(arrivalDetailUW);

                receiptDetailManager.removeByReceiptId(entity.getId());
            }

            //还原发货单和发货单明细状态
            accessoryService.removeBySourceId(entity.getId());
        }

        this.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(detailList) && detailList.size()>0){
            detailList.forEach(s->s.setReceiptId(entity.getId()));
            receiptDetailManager.saveBatch(detailList);

            List<String> collect = detailList.stream().map(s -> s.getArrivalId()).distinct().collect(Collectors.toList());
            List<String> collect1 = detailList.stream().map(s -> s.getArrivalDetailId()).distinct().collect(Collectors.toList());

            LambdaUpdateWrapper<ArrivalDetail> arrivalDetailUW = new LambdaUpdateWrapper<>();
            arrivalDetailUW.set(ArrivalDetail::getStatus,2)
                    .in(ArrivalDetail::getId,collect1);
            arrivalDetailManager.update(arrivalDetailUW);

            for(String arrId : collect){
                LambdaQueryWrapper<ArrivalDetail> arrDetailCountQW = new LambdaQueryWrapper<>();
                arrDetailCountQW.eq(ArrivalDetail::getStatus,1)
                        .eq(ArrivalDetail::getArrivalId,arrId);
                if(arrivalDetailManager.count(arrDetailCountQW)==0){
                    LambdaUpdateWrapper<Arrival> arrivalUW = new LambdaUpdateWrapper<>();
                    arrivalUW.set(Arrival::getStatus,3)
                            .eq(Arrival::getId,arrId)
                            .eq(Arrival::getIsDele,"0");
                    arrivalManager.update(arrivalUW);
                }
            }
        }

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

        return entity.getId();
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        receiptDetailManager.removeByReceiptId(String.join(",",ids));
        accessoryService.removeBySourceIds(ids);
        super.removeByIds(ids);
    }


    //2024-08-16 17:03
//    @Override
//    @Transactional
//    public String saveVo(BizReceipt entity) {
//        List<BizReceiptDetail> detailList = entity.getDetailList();
//
//        if(BeanUtils.isEmpty(entity.getId())){
//            //新增
//            if(BeanUtils.isEmpty(entity.getReceiptCode())){
//                String bacthNum = BizUtils.getNextSerialNumber(systemConfigFeignService, "cgpt_cgfh");
//                entity.setReceiptCode(bacthNum);
//            }
//            entity.setStatus(1);
//        }else {
//            //更新
//            receiptDetailManager.removeByReceiptId(entity.getId());
//
//        }
//
//        this.saveOrUpdate(entity);
//
//        if(BeanUtils.isNotEmpty(detailList) && detailList.size()>0){
//            for(BizReceiptDetail detail : detailList) {
//                detail.setReceiptId(entity.getId());
//
//                if(null != detail.getId()){
//                    BizReceiptDetail detailOld = receiptDetailManager.getById(detail.getId());
//                    if(!detailOld.getNum().equals(detail.getNum())){
//                        BizReceiptHandle handle = new BizReceiptHandle();
//                        handle.setNum(detail.getNum());
//                        handle.setOldNum(detailOld.getNum());
//                        handle.setReceiptDetailId(detail.getId());
//                        IGroup currentGroup = ContextUtil.getCurrentGroup();
//                        handle.setOperaterCompanyId(currentGroup.getGroupId());
//                        handle.setOperaterCompanyCode(currentGroup.getGroupCode());
//                        handle.setOperaterCompanyName(currentGroup.getName());
//                        handle.setOperaterUserId(baseContext.getCurrentUserId());
//                        handle.setOperaterUserName(baseContext.getCurrentUserName());
//                        bizReceiptHandleManager.save(handle);
//                    }
//                    receiptDetailManager.saveOrUpdate(detail);
//                }else {
//                    receiptDetailManager.saveOrUpdate(detail);
//                    BizReceiptHandle handle = new BizReceiptHandle();
//                    handle.setNum(detail.getNum());
//                    handle.setOldNum(BigDecimal.ZERO);
//                    handle.setReceiptDetailId(detail.getId());
//                    IGroup currentGroup = ContextUtil.getCurrentGroup();
//                    handle.setOperaterCompanyId(currentGroup.getGroupId());
//                    handle.setOperaterCompanyCode(currentGroup.getGroupCode());
//                    handle.setOperaterCompanyName(currentGroup.getName());
//                    handle.setOperaterUserId(baseContext.getCurrentUserId());
//                    handle.setOperaterUserName(baseContext.getCurrentUserName());
//                    bizReceiptHandleManager.save(handle);
//                }
//            }
//        }
//
//        return entity.getId();
//    }

    @Override
    @Transactional
    public void updateStatus(String id, Integer status) {
        //状态（1：未发货 ，2：已发货，3： 已收货，4：已结算
        LambdaUpdateWrapper<BizReceipt> uw = new LambdaUpdateWrapper<>();
        uw.set(BizReceipt::getStatus,status)
                .eq(BizReceipt::getId,id)
                .eq(BizReceipt::getIsDele,"0");
        if(status == 3){
            //收货
            IUser user = ContextUtil.getCurrentUser();
            uw.set(BizReceipt::getMatUserId,user.getUserId())
                    .set(BizReceipt::getMatUserName,user.getFullname())
                    .set(BizReceipt::getMatUserPhone,user.getMobile())
                    .set(BizReceipt::getReceiptDate, LocalDateTime.now());
            LambdaUpdateWrapper<BizReceiptDetail> detailUW = new LambdaUpdateWrapper<>();
            detailUW.set(BizReceiptDetail::getStatus,2)
                    .eq(BizReceiptDetail::getReceiptId,id);
            receiptDetailManager.update(detailUW);
        }

        super.update(uw);

    }

    @Override
    public PageList<BizReceipt> pageVendorGroup(QueryFilter<BizReceipt> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<BizReceipt> result = baseMapper.pageVendorGroup(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
