package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.receipt.manager.BizReceiptHandleManager;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import com.artfess.cgpt.receipt.dao.BizReceiptDetailDao;
import com.artfess.cgpt.receipt.manager.BizReceiptDetailManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.receipt.model.BizReceiptHandle;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 采购收货单明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizReceiptDetailManagerImpl extends BaseManagerImpl<BizReceiptDetailDao, BizReceiptDetail> implements BizReceiptDetailManager {

    @Resource
    private BizReceiptHandleManager bizReceiptHandleManager;
    @Resource
    private UCFeignService ucFeignService;
    @Resource
    private BaseContext baseContext;

    @Override
    public List<BizReceiptDetail> getByReceiptId(String receipitId) {
        LambdaQueryWrapper<BizReceiptDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BizReceiptDetail::getReceiptId,receipitId);
        List<BizReceiptDetail> list = this.list(wrapper);
        return list;
    }


    @Override
    @Transactional
    public void removeByReceiptId(String receiptIds) {
        List<String> receiptIdList = Arrays.asList(receiptIds.split(","));
        LambdaQueryWrapper<BizReceiptDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(BizReceiptDetail::getReceiptId,receiptIdList);
        this.remove(wrapper);
    }

    @Override
    public PageList<BizReceiptDetail> queryAllPage(QueryFilter<BizReceiptDetail> queryFilter) {
        IPage<BizReceiptDetail> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList(result);
    }


    @Override
    public void removeHandleLog(List<String> ids) {
        List<BizReceiptDetail> details = this.listByIds(ids);

        for (BizReceiptDetail detail : details) {
            BizReceiptHandle handle = new BizReceiptHandle();
            handle.setNum(detail.getReceiptNum());
            handle.setOldNum(detail.getArrivalNum());
            handle.setReceiptDetailId(detail.getId());
            handle.setOperaterCompanyId(baseContext.getCurrentDeptId());
            handle.setOperaterCompanyName(baseContext.getCurrentDeptName());
            handle.setOperaterUserId(baseContext.getCurrentUserId());
            handle.setOperaterUserName(baseContext.getCurrentUserName());
            bizReceiptHandleManager.save(handle);
            this.update(detail);
        }

    }

    @Override
    public BizReceiptDetail getDetail(String id) {
        BizReceiptDetail detail = this.getById(id);
        List<BizReceiptHandle> handles=  bizReceiptHandleManager.getByDetailId(id);

        detail.setHandles(handles);
        return detail;
    }

    //
//    @Override
//    public void confirm(List<String> ids) {
//        List<BizReceiptDetail> details = this.listByIds(ids);
//
//        for (BizReceiptDetail detail : details) {
//            //收货状态（1：未收货 ，2：已收货）
//            detail.setStatus(2);
//        }
//        this.updateBatchById(details);
//
//
//    }
}
