package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.receipt.dao.ArrivalDetailDao;
import com.artfess.cgpt.receipt.manager.ArrivalDetailManager;
import com.artfess.cgpt.receipt.model.ArrivalDetail;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import com.artfess.cgpt.receipt.model.BizReceiptHandle;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/19 20:29
 */
@Service
public class ArrivalDetailManagerImpl extends BaseManagerImpl<ArrivalDetailDao, ArrivalDetail> implements ArrivalDetailManager {

    @Override
    public List<ArrivalDetail> getByArrivalId(String arrivalId) {
        LambdaQueryWrapper<ArrivalDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ArrivalDetail::getArrivalId,arrivalId);
        List<ArrivalDetail> list = this.list(wrapper);
        return list;
    }

    @Override
    @Transactional
    public void removeByArrivalId(String arrivalId) {
        List<String> arrivalIdList = Arrays.asList(arrivalId.split(","));
        LambdaQueryWrapper<ArrivalDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ArrivalDetail::getArrivalId,arrivalIdList);
        this.remove(wrapper);
    }

    @Override
    public ArrivalDetail getDetail(String id) {
        ArrivalDetail result = super.getById(id);
        return result;
    }

    @Override
    public PageList<ArrivalDetail> queryAllPage(QueryFilter<ArrivalDetail> queryFilter) {
        IPage<ArrivalDetail> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList(result);
    }

}
