package com.artfess.cgpt.receipt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.receipt.model.BizReconciliation;
import com.artfess.cgpt.receipt.vo.BizReconciliationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.receipt.model.BizReconciliation;
import com.artfess.cgpt.receipt.manager.BizReconciliationManager;

import java.util.Arrays;
import java.util.List;

/**
 * 对账单表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@RestController
@RequestMapping("/bizReconciliation/v1/")
@Api(tags = "对账单表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReconciliationController extends BaseController<BizReconciliationManager, BizReconciliation> {

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizReconciliation>> queryAllByPage(@ApiParam(name="queryFilter",value = "通用查询器")@RequestBody QueryFilter<BizReconciliation> queryFilter){
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        PageList<BizReconciliation> result=baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-查询详情")
    public CommonResult<BizReconciliation> selectOne(@RequestParam("id") String id){
        BizReconciliation result = baseService.getDetail(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-根据id批量删除")
    public CommonResult remove(@RequestBody List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult save(@RequestBody BizReconciliation entity) {
        String id = baseService.saveVo(entity);
        return new CommonResult<>(true, "操作成功",id);
    }

    @PostMapping("/updateStatus")
    @ApiOperation(value = "M-根据ids修改状态")
    public CommonResult updateStatus(@RequestParam("ids") String ids,@RequestParam("status") Integer status){
        baseService.updateStatus(ids,status);
        return new CommonResult<>(true,"操作成功",ids);
    }

    /**
     * 推送到支付平台
     * @param ids ID主键集合
     * @return
     */
    @PostMapping("/pushToZfpt")
    @ApiOperation(value = "M-推送到支付平台",notes = "参数说明：ids：ID主键集合",httpMethod = "POST")
    public CommonResult pushToZfpt(@RequestParam("ids") String ids) {
        baseService.pushToZfpt(Arrays.asList(ids.split(",")));
        return new CommonResult<>(true,"操作成功");
    }

    //支付状态（0：买方未确认，1：买方已确认，2：已支付，3：未发布，4：买方不同意，默认3）
//    @PostMapping("/withdraw")
//    @ApiOperation(value = "S-对账单撤回")
//    public CommonResult withdrawReceipt(@RequestParam String id){
//        baseService.updateStatus(id,3);
//        return new CommonResult<>(true,"操作成功");
//    }
//
//    @PostMapping("/confrim")
//    @ApiOperation(value = "S-对账单确认")
//    public CommonResult confrimReceipt(@RequestParam String id){
//        baseService.updateStatus(id,1);
//        return new CommonResult<>(true,"操作成功");
//    }
//
//    @PostMapping("/release")
//    @ApiOperation(value = "S-对账单发布")
//    public CommonResult releaseReceipt(@RequestParam String id){
//        baseService.updateStatus(id,0);
//        return new CommonResult<>(true,"操作成功");
//    }
//
//    @PostMapping("/refuse")
//    @ApiOperation(value = "S-买方拒绝")
//    public CommonResult refuseReceipt(@RequestParam String id,@RequestParam String reason){
//        baseService.refuseReceipt(id,reason);
//        return new CommonResult<>(true,"操作成功");
//    }

}
