package com.artfess.cgpt.receipt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrder;
import com.artfess.cgpt.receipt.manager.BizReceiptManager;
import com.artfess.cgpt.receipt.model.BizReceipt;
import com.artfess.cgpt.receipt.vo.ReceiptVo;
import com.artfess.cgpt.utils.BizUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 采购收货单表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@RestController
@RequestMapping("/bizReceipt/v1/")
@Api(tags = "采购收货单表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReceiptController extends BaseController<BizReceiptManager, BizReceipt> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizReceipt>> queryAllByPage(@RequestBody QueryFilter<BizReceipt> queryFilter){
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        PageList<BizReceipt> result = baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-查询详情")
    public CommonResult<BizReceipt> selectOne(@RequestParam("id") String id){
        BizReceipt result = baseService.getDetailById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-根据id批量删除")
    public CommonResult remove(@RequestBody List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult save(@RequestBody BizReceipt entity) {
        String id = baseService.saveVo(entity);
        return new CommonResult<>(true, "操作成功",id);
    }

    @PostMapping("/updateStatus")
    @ApiOperation(value = "M-根据id修改状态")
    public CommonResult updateStatus(@RequestParam("id") String id,@RequestParam("status") Integer status){
        baseService.updateStatus(id,status);
        return new CommonResult<>(true,"操作成功",id);
    }

    @PostMapping("/pageVendorGroup")
    @ApiOperation(value = "M-分页查询供应商分组")
    public CommonResult<PageList<BizReceipt>> pageVendorGroup(@RequestBody QueryFilter<BizReceipt> queryFilter){
        PageList<BizReceipt> result = baseService.pageVendorGroup(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

//    @PostMapping("/confrim_send")
//    @ApiOperation(value = "S-确认发货")
//    public CommonResult confrimSend(@RequestParam String id){
//        baseService.updateStatus(id,2);
//        return new CommonResult<>(true,"操作成功");
//    }
//
//    @PostMapping("/confrim_receipt")
//    @ApiOperation(value = "S-确认收货")
//    public CommonResult confrimReceipt(@RequestParam String id){
//        baseService.updateStatus(id,3);
//        return new CommonResult<>(true,"操作成功");
//    }

//    @PostMapping("/update_status")
//    @ApiOperation(value = "S-修改状态 //状态（1：未发货 ，2：已发货，3： 已收货，4：已结算" )
//    public CommonResult updateStatus(@RequestParam String id,@RequestParam Integer status){
//       baseService.updateStatus(id,status);
//        return new CommonResult<>(true,"查询成功");
//    }

}
