package com.artfess.cgpt.receipt.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.receipt.manager.ArrivalDetailManager;
import com.artfess.cgpt.receipt.model.ArrivalDetail;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description:采购发货明细表
 * @Author: Rong Tao
 * @Date: 2024/8/19 20:30
 */
@RestController
@RequestMapping("/arrivalDetail/v1/")
@Api(tags = "采购发货单表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ArrivalDetailController extends BaseController<ArrivalDetailManager, ArrivalDetail> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<ArrivalDetail>> queryAllByPage(@RequestBody QueryFilter<ArrivalDetail> queryFilter){
        PageList<ArrivalDetail> result = baseService.queryAllPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

}
