package com.artfess.cgpt.qualification.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 资质类型表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizQualificationCategory对象", description="资质类型表")
@Data
@TableName("biz_qualification_category")
public class BizQualificationCategory extends BizModel<BizQualificationCategory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资质类别编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "资质类别名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "限制文件大小（MB），空或者0表示不限制")
    @TableField("FILE_SIZE_")
    private Integer fileSize;

    @ApiModelProperty(value = "限制文件数量，空或者0表示不限制")
    @TableField("FILE_NUM_")
    private Integer fileNum;

    @ApiModelProperty(value = "是否限制有效期（0：不限制，1：限制）")
    @TableField("LIMITATION_")
    private String limitation;

    @ApiModelProperty(value = "到期处理方式（0：冻结，1：提醒）")
    @TableField("EXPIRATION_PROCESSING_METHOD_")
    private String expirationProcessingMethod;

    @ApiModelProperty(value = "是否需要审批（0：不需要审批，1：需要审批）")
    @TableField("CHANGE_APPROVAL_")
    private String changeApproval;

    @ApiModelProperty(value = "审批方式（0：企业审批，1：平台审批）")
    @TableField("CHANGE_APPROVAL_METHOD_")
    private String changeApprovalMethod;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIBE_")
    private String describe;

}
