package com.artfess.cgpt.qualification.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseQualificationLabelManager;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.expert.model.BizExpertDatabaseQualificationLabel;
import com.artfess.cgpt.project.manager.UserParticipationQualificationLabelManager;
import com.artfess.cgpt.project.model.UserParticipationQualificationLabel;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.qualification.dao.BizQualificationLabelDao;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgQualificationLabelManager;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 资质库表，该表需要上传附件 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizQualificationLabelManagerImpl extends BaseManagerImpl<BizQualificationLabelDao, BizQualificationLabel> implements BizQualificationLabelManager {

    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizExpertDatabaseQualificationLabelManager expertDatabaseQualificationLabelManager;
    @Autowired
    private BizSupplierOrgQualificationLabelManager supplierOrgQualificationLabelManager;
    @Autowired
    private UserParticipationQualificationLabelManager userParticipationQualificationLabelManager;

    /**
     * 资质来源-个人
     */
    private final String QUALIFICATION_FROM = "3";

    @Override
    public PageList<BizQualificationLabel> queryAllByPage(QueryFilter<BizQualificationLabel> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<BizQualificationLabel> iPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);

    }

    @Override
    @Transactional
    public String saveOrUpdateEntity(BizQualificationLabel entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        // 资质来源为个人时，取当前登录用户信息
        if (QUALIFICATION_FROM.equals(entity.getQualificationForm())) {
            entity.setQualificationMemberId(ContextUtil.getCurrentUser().getUserId());
            entity.setQualificationMember(ContextUtil.getCurrentUser().getFullname());
        }

        Assert.notNull(entity.getQualificationMemberId(), "资质关联成员ID不能为空！");
        Assert.notNull(entity.getQualificationMember(), "资质关联成员不能为空！");

        if (BeanUtils.isEmpty(entity.getId())) {
            //新增，设置资质编码
            if(BeanUtils.isEmpty(entity.getQualificationCode())){
                entity.setQualificationCode(BizUtils.getNextSerialNumber(systemConfigFeignService, "cgpt_zzbm"));
            }
        } else {
            //更新
            //判断是否存在关联数据，如果存在，不能编辑
            existData(entity);
            //删除然后重新添加附件
            accessoryService.removeBySourceId(entity.getId());
        }

        super.saveOrUpdate(entity);

        if (BeanUtils.isNotEmpty(accessoryList)) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

        return entity.getId();
    }

    @Override
    public BizQualificationLabel getDataById(String id) {
        BizQualificationLabel result = super.getById(id);
        // 查询附件信息
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(result.getId()));
        return result;
    }

    @Override
    public void removeByIds(List<String> ids) {
        List<BizQualificationLabel> bizQualificationLabelList = super.listByIds(ids);
        for(BizQualificationLabel data : bizQualificationLabelList){
            //判断是否存在关联数据，如果存在，不能删除
            existData(data);
        }
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public void updateApprovalStatusById(String id, String status) {
        LambdaUpdateWrapper<BizQualificationLabel> qualificationLabelUW = new LambdaUpdateWrapper<>();
        qualificationLabelUW.set(BizQualificationLabel::getApprovalStatus,status)
                .eq(BizQualificationLabel::getId,id)
                .eq(BizQualificationLabel::getIsDele,"0");
        super.update(qualificationLabelUW);
    }

    /**
     * 校验是否已存在关联数据
     * @param data
     */
    void existData(BizQualificationLabel data){
        //查询专家资质关联表
        LambdaQueryWrapper<BizExpertDatabaseQualificationLabel> expertDatabaseQW = new LambdaQueryWrapper<>();
        expertDatabaseQW.eq(BizExpertDatabaseQualificationLabel::getQualificationLabelId,data.getId());
        if(expertDatabaseQualificationLabelManager.count(expertDatabaseQW)>0){
            throw new BaseException("资质编码【"+data.getQualificationCode()+"】已存在关联数据，无法删除");
        }

        //查询准入供应商资质关联表
        LambdaQueryWrapper<BizSupplierOrgQualificationLabel> supplierOrgQualificationLabelQW = new LambdaQueryWrapper<>();
        supplierOrgQualificationLabelQW.eq(BizSupplierOrgQualificationLabel::getQualificationLabelId,data.getId());
        if(supplierOrgQualificationLabelManager.count(supplierOrgQualificationLabelQW)>0){
            throw new BaseException("资质编码【"+data.getQualificationCode()+"】已存在关联数据，无法删除");
        }

        //查询参与报名资质关联表
        LambdaQueryWrapper<UserParticipationQualificationLabel> userParticipationQualificationLabelQW = new LambdaQueryWrapper<>();
        userParticipationQualificationLabelQW.eq(UserParticipationQualificationLabel::getQualificationLabelId,data.getId());
        if(userParticipationQualificationLabelManager.count(userParticipationQualificationLabelQW)>0){
            throw new BaseException("资质编码【"+data.getQualificationCode()+"】已存在关联数据，无法删除");
        }
    }

}
