package com.artfess.cgpt.qualification.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.qualification.manager.BizQualificationCategoryManager;

import java.util.List;

/**
 * 资质类型表 前端控制器
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizQualificationCategory/v1/")
@Api(tags = "资质类型")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizQualificationCategoryController extends BaseController<BizQualificationCategoryManager, BizQualificationCategory> {

    @Autowired
    private UCFeignService ucFeignService;

    @RequestMapping(value = "/saveCategory", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "M-添加或修改资质类型")
    public CommonResult<List<BizQualificationCategory>> saveCategory(@RequestBody BizQualificationCategory entity) {
//        boolean admin = BizUtils.isAdmin(ucFeignService);
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");

    }
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizQualificationCategory>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizQualificationCategory> queryFilter){
        PageList<BizQualificationCategory> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizQualificationCategory> selectOne(@ApiParam(name="queryfilter",value = "通用查询器")@RequestParam String id){
        BizQualificationCategory result=baseService.getById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }
}
