package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description: 报价模版明细_立项关联表
 * @Author: Rong Tao
 * @Date: 2024/3/26 18:29
 */
@ApiModel(value="QuotationTemplateDetailApproval对象", description="报价模版明细_立项关联表")
@TableName("biz_quotation_template_detail_approval")
@Data
public class QuotationTemplateDetailApproval extends BizModel<QuotationTemplateDetailApproval> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项类型（1.物资，2.项目）")
    @TableField("PROJECT_APPROVAL_TYPE_")
    private Integer projectApprovalType;

    @ApiModelProperty(value = "立项ID（关联项目立项表ID）")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "报价模版ID（关联报价模版表ID）")
    @TableField("TEMPLATE_ID_")
    private String templateId;

    @ApiModelProperty(value = "报价列名称")
    @TableField("QUO_ARRANGE_")
    private String quoArrange;

    @ApiModelProperty(value = "是否必填（0：否，1：是）")
    @TableField("IS_REQUIRED_")
    private Integer isRequired;

    @ApiModelProperty(value = "招标录入项（0：否，1：是）")
    @TableField("BECKON_ENTRY_")
    private Integer beckonEntry;

    @ApiModelProperty(value = "投标录入项（0：否，1：是）")
    @TableField("THROW_ENTRY_")
    private Integer throwEntry;

    @ApiModelProperty(value = "投标显示项（0：否，1：是）")
    @TableField("THROW_SHOW_")
    private Integer throwShow;

    @ApiModelProperty(value = "评标显示项（0：否，1：是）")
    @TableField("EVALUATION_SHOW_")
    private Integer evaluationShow;

    @ApiModelProperty(value = "价格录入项（0：否，1：是）")
    @TableField("PRICE_ENTRY_")
    private Integer priceEntry;

    @ApiModelProperty(value = "来源类型")
    @TableField("SOURCE_TYPE_")
    private String sourceType;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
