package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:采购审批规则明细
 * @Author: Rong Tao
 * @Date: 2024/7/22 14:07
 */
@ApiModel(value="purchasingRulesDetail对象", description="采购审批规则明细")
@TableName("biz_purchasing_rules_detail")
@Data
public class PurchasingRulesDetail extends BizNoModel<PurchasingRulesDetail> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "审批规则表ID")
    @TableField("PURCHASING_RULES_ID_")
    private String purchasingRulesId;

    @ApiModelProperty(value = "审批菜单别名")
    @TableField("APPROVAL_MENU_ALIAS_")
    private String approvalMenuAlias;

    @ApiModelProperty(value = "采购公司ID")
    @TableField(exist = false)
    private String procureOrgId;
    @ApiModelProperty(value = "采购公司编码")
    @TableField(exist = false)
    private String procureOrgCode;
    @ApiModelProperty(value = "采购公司名称")
    @TableField(exist = false)
    private String procureOrgName;
}
