package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * @Description: 采购申请合并记录表
 * @Author: Rong Tao
 * @Date: 2024/3/25 18:45
 */
@ApiModel(value="PurchasingApplicationRecords对象", description="采购申请合并记录表")
@TableName("biz_purchasing_application_records")
@Data
public class PurchasingApplicationRecords extends BizModel<PurchasingApplicationRecords> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "原始采购申请ID（关联采购申请表ID）")
    @TableField("OLD_APPLICATION_ID_")
    private String oldApplicationId;

    @ApiModelProperty(value = "合并前采购申请ID（关联采购申请表ID）")
    @TableField("MERGE_PRE_APPLICATION_ID_")
    private String mergePreApplicationId;

    @ApiModelProperty(value = "合并后采购申请ID（关联采购申请表ID）")
    @TableField("MERGE_AFTER_APPLICATION_ID_")
    private String mergeAfterApplicationId;

    @ApiModelProperty(value = "合并父级ID")
    @TableField("MERGE_PID_")
    private String mergePid;

    @ApiModelProperty(value = "合并状态（1.未合并，2.已合并）")
    @TableField("MERGE_STATUS_")
    private Integer mergeStatus;

    @ApiModelProperty(value = "组织ID（关联组织表ID）")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "批次号")
    @TableField("MERGE_NUM_")
    private String mergeNum;

    @ApiModelProperty(value = "操作类型（1.合并，2.还原）")
    @TableField("OPERATER_TYPE_")
    private Integer operaterType;

    @ApiModelProperty(value = "申请类型（使用字典，1：标准采购申请，）")
    @TableField("APPLICATION_TYPE_")
    private String applicationType;

    @ApiModelProperty(value = "申请单编号（自动生成，格式：CGSQ yyyymm00001）")
    @TableField("APPLICATION_NUM_")
    private String applicationNum;

    @ApiModelProperty(value = "是否含税价（1：价外税，2：价内税）")
    @TableField("IS_TAX_")
    private String isTax;

    @ApiModelProperty(value = "编制人ID")
    @TableField("PREPARED_USER_ID_")
    private String preparedUserId;

    @ApiModelProperty(value = "编制人姓名")
    @TableField("PREPARED_USER_NAME_")
    private String preparedUserName;

    @ApiModelProperty(value = "编制公司ID")
    @TableField("PREPARED_ORG_ID_")
    private String preparedOrgId;

    @ApiModelProperty(value = "编制公司名称")
    @TableField("PREPARED_ORG_NAME_")
    private String preparedOrgName;

    @ApiModelProperty(value = "编制公司编码")
    @TableField("PREPARED_ORG_CODE_")
    private String preparedOrgCode;

    @ApiModelProperty(value = "编制日期")
    @TableField("PREPARED_DATE_")
    private LocalDate preparedDate;

    @ApiModelProperty(value = "采购日期")
    @TableField("APPLICATION_DATE_")
    private LocalDate applicationDate;

    @ApiModelProperty(value = "采购类型（1.物资，2.项目）")
    @TableField("PROCUREMENT_TYPE_")
    private Integer procurementType;

    @ApiModelProperty(value = "采购方式（1：平台定价，2：合同采购，3：企业线下定价【单一采购】）")
    @TableField("PROCUREMENT_METHOD_")
    private String procurementMethod;

    @ApiModelProperty(value = "招标方式（1：招标采购，2：询比价采购，3：竞价采购，"+
            "4：竞争性谈判，5：单一来源采购，6：多源采购，7：框架协议，"+
            "8：邀请招标采购）")
    @TableField("APPLICATION_METHOD_")
    private String applicationMethod;

    @ApiModelProperty(value = "有无资质要求（0：无，1：有）")
    @TableField("HAS_QUALIFICATION_")
    private String hasQualification;

    @ApiModelProperty(value = "来源类型（1.手工录入，系统导入）")
    @TableField("APPLICATION_SOURCE_")
    private String applicationSource;

    @ApiModelProperty(value = "是否集中采购（0：自采，1：集采）")
    @TableField("MAT_IF_PLAT_")
    private Integer matIfPlat;

    @ApiModelProperty(value = "计划类型（1.月度计划，2.季度计划，3.年度计划，4.临期计划）")
    @TableField("PLAN_TYPE_")
    private Integer planType;

    @ApiModelProperty(value = "状态（1：草稿，2：审批中，3：已审批，4：已立项，5：流标，6：已发中选公示，7：已签订合同）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
