package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.bidding.model.BiddingQuotationTemplateDetailData;
import com.artfess.cgpt.bidding.model.QuotationTemplateDetail;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.math.BigDecimal;
import java.text.Bidi;
import java.time.LocalDate;
import java.util.List;

/**
 * @Description: 物料采购立项明细表
 * @Author: Rong Tao
 * @Date: 2024/3/26 10:16
 */
@ApiModel(value="MatApprovalDetails对象", description="物料采购立项明细表")
@TableName("biz_mat_approval_details")
@Data
public class MatApprovalDetails extends BizModel<MatApprovalDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项ID（关联采购立项表ID）")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购申请明细ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_DETAIL_ID_")
    private String purchasingApplicationDetailId;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_NUMBER_")
    private String noticeNumber;

    @ApiModelProperty(value = "报价轮数（默认1）")
    @TableField("QUOTATION_ROUNDS_")
    private Integer quotationRounds;

    @ApiModelProperty(value = "物料ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    @Excel(name = "平台物料编号")
    private String matPlatcode;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    @Excel(name = "数量")
    private BigDecimal matNum;

    @ApiModelProperty(value = "最高限价(元)")
    @TableField("MAXIMUM_PRICE_LIMIT_")
    @Excel(name = "最高限价(元)")
    private BigDecimal maximumPriceLimit;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @TableField(exist = false)
    @Excel(name = "需求日期")
    private String demandDateValue;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    @Excel(name = "计划编号")
    private String planCode;

    @ApiModelProperty(value = "送货地址")
    @TableField("UNLOAD_ADDRESS_")
    @Excel(name = "送货地址(导入时请填入【送货地址管理】菜单中对应的的编号)")
    private String unloadAddress;

    @ApiModelProperty(value = "企业补充说明")
    @TableField("REMARKS_")
    @Excel(name = "企业补充说明")
    private String remarks;

    @ApiModelProperty(value = "物料分类编号")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料编码")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "物料状态（1：未评标，2：已评标，3：已定标，4：已发送成交通知 ，5：已中标，6：流标）")
    @TableField("BID_STATUS_")
    private Integer bidStatus;

    @ApiModelProperty(value = "当前最低报价")
    @TableField(exist = false)
    private BigDecimal minQuoPrice;

    @ApiModelProperty(value = "我的报价（单价）")
    @TableField(exist = false)
    private BigDecimal myPrice;
    @ApiModelProperty(value = "我的报价（总额）")
    @TableField(exist = false)
    private BigDecimal myAmount;

    @ApiModelProperty(value = "报价公司id")
    @TableField(exist = false)
    private String quoCompanyId;
    @ApiModelProperty(value = "报价公司编号")
    @TableField(exist = false)
    private String quoCompanyCode;
    @ApiModelProperty(value = "报价公司名称")
    @TableField(exist = false)
    private String quoCompanyName;

    @ApiModelProperty(value = "评标状态（0.未评标，1.已评标）")
    @TableField(exist = false)
    private Integer isEva;

    @ApiModelProperty(value = "投标补充说明")
    @TableField(exist = false)
    private String tenderExplain;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;


    @ApiModelProperty(value = "报价模版明细")
    @TableField(exist = false)
    private List<QuotationTemplateDetail> quotationTemplateDetailList;

    @ApiModelProperty(value = "报价模版明细数据")
    @TableField(exist = false)
    private List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList;

    @ApiModelProperty(value = "报价排名（由低到高）")
    @TableField(exist = false)
    private Integer rank;

//    @ApiModelProperty(value = "报价金额")
//    @TableField(exist = false)
//    private BigDecimal quoPrice;

}
