package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:物料采购立项明细_报价模版明细关联数据表
 * @Author: Rong Tao
 * @Date: 2024/3/28 14:05
 */
@ApiModel(value="MatApprovalDetailQuotationTemplateDetailData对象", description="物料采购立项明细_报价模版明细关联数据表")
@TableName("biz_mat_approval_detail_quotation_template_data")
@Data
public class MatApprovalDetailQuotationTemplateDetailData extends BizModel<MatApprovalDetailQuotationTemplateDetailData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项明细ID，关联采购立项明细表ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "报价模版ID（关联报价模版表ID）")
    @TableField("TEMPLATE_ID_")
    private String templateId;

    @ApiModelProperty(value = "报价模版明细ID")
    @TableField("TEMPLATE_DETAIL_ID_")
    private String templateDetailId;

    @ApiModelProperty(value = "参数值")
    @TableField("VALUE_")
    private String value;

}
