package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 澄清提问，有附件
 * @Author: Rong Tao
 * @Date: 2024/3/27 17:36
 */
@ApiModel(value="ClarifyQuestions对象", description="澄清提问，有附件")
@TableName("biz_clarify_questions")
@Data
public class ClarifyQuestions extends BizNoModel<ClarifyQuestions> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购立项ID（关联采购立项表ID）")
    @TableField("PROJECT_APPROVAL_ID_")
    private String projectApprovalId;

    @ApiModelProperty(value = "立项类型（1.物资，2.项目）")
    @TableField("PROJECT_APPROVAL_TYPE_")
    private Integer projectApprovalType;

    @ApiModelProperty(value = "操作人ID")
    @TableField("OPERATE_ID_")
    private String operateId;

    @ApiModelProperty(value = "操作人姓名")
    @TableField("OPERATE_NAME_")
    private String operateName;

    @ApiModelProperty(value = "操作企业ID")
    @TableField("OPERATE_ORG_ID_")
    private String operateOrgId;

    @ApiModelProperty(value = "操作企业编号")
    @TableField("OPERATE_ORG_CODE_")
    private String operateOrgCode;

    @ApiModelProperty(value = "操作企业名称")
    @TableField("OPERATE_ORG_NAME_")
    private String operateOrgName;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIBE_")
    private String describe;

    @ApiModelProperty(value = "提问时间")
    @TableField("OPERATE_TIME_")
    private LocalDateTime operateTime;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

    @ApiModelProperty(value = "回答集合")
    @TableField(exist = false)
    private List<ClarifyAnswer> answerList;

}
