package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购订单表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@ApiModel(value="BizPurchaseOrder对象", description="采购订单表")
@TableName("biz_purchase_order")
@Data
public class BizPurchaseOrder extends BizModel<BizPurchaseOrder> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "订单编号")
    @TableField("ORDER_CODE_")
    private String orderCode;

    @ApiModelProperty(value = "合同ID")
    @TableField("CONTRACT_ID")
    private String contractId;

    @ApiModelProperty(value = "合同编号")
    @TableField("CONTRACT_NUMBER_")
    private String contractNumber;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "采购公司编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "供应商ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "供应商名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "供应商编号")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "不含税金额")
    @TableField("ORDER_AMOUNT_")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "含税金额")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "编制时间")
    @TableField("ORDER_CREATEDATE_")
    private LocalDateTime orderCreatedate;

    @ApiModelProperty(value = "最后修改日期")
    @TableField("ORDER_LASTCHGDATE_")
    private LocalDateTime orderLastchgdate;

    @ApiModelProperty(value = "状态（1.草稿，2.供应商待确认，3.已确认，4.不同意），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "附件信息")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

    @ApiModelProperty(value = "订单明细")
    @TableField(exist = false)
    private List<BizPurchaseOrderDetail> detailsList;

    @ApiModelProperty(value = "合同ID集合")
    @TableField(exist = false)
    private List<String> contractIdList;

}
