package com.artfess.cgpt.purchasing.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.*;
import com.artfess.cgpt.bidding.model.*;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.purchasing.dao.MatApprovalDao;
import com.artfess.cgpt.purchasing.dao.MatApprovalDetailsDao;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.ProjectEvaluationExpertManager;
import com.artfess.cgpt.purchasing.manager.TenderDocumentManager;
import com.artfess.cgpt.purchasing.model.*;
import com.artfess.cgpt.purchasing.vo.MatApprovalDetailsEvaExportVO;
import com.artfess.cgpt.purchasing.vo.MatApprovalDetailsExportVO;
import com.artfess.cgpt.purchasing.vo.MatApprovalDetailsImportVO;
import com.artfess.cgpt.supplier.manager.BizDeliveryAddressManager;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.BizDeliveryAddress;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.googlecode.aviator.utils.ArrayHashMap;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 10:22
 */
@Service
public class MatApprovalDetailsManagerImpl extends BaseManagerImpl<MatApprovalDetailsDao, MatApprovalDetails> implements MatApprovalDetailsManager {

    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    MatApprovalManager approvalManager;
    @Autowired
    private TenderDocumentManager tenderDocumentManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ProjectEvaluationExpertManager evaluationExpertManager;
    @Autowired
    private BizMaterialManager materialManager;
    @Autowired
    private BizDeliveryAddressManager addressManager;
    @Autowired
    private QuotationTemplateDetailManager quotationTemplateDetailManager;
    @Autowired
    private BiddingQuotationTemplateDetailDataManager biddingQuotationTemplateDetailDataManager;
    @Autowired
    private BidEvaluationRecordManager evaluationRecordManager;
    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private BizBidEvaluationManager bidEvaManager;

    @Override
    public PageList<MatApprovalDetails> queryAllByPage(QueryFilter<MatApprovalDetails> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
        IPage<MatApprovalDetails> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<MatApprovalDetails> pageEvaDetail(QueryFilter<MatApprovalDetails> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
        IPage<MatApprovalDetails> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<MatApprovalDetails> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(MatApprovalDetails temp : records){
                //查询是否评标
                LambdaQueryWrapper<BidEvaluationRecord> evaRecordQW = new LambdaQueryWrapper<>();
                evaRecordQW.eq(BidEvaluationRecord::getNoticeId,temp.getNoticeId())
                        .eq(BidEvaluationRecord::getNoticeDetailedId,temp.getId())
                        .eq(BidEvaluationRecord::getOperateUserId,ContextUtil.getCurrentUserId())
                        .eq(BidEvaluationRecord::getStatus,2);
                if(evaluationRecordManager.count(evaRecordQW)>0){
                    temp.setIsEva(1);
                }else {
                    temp.setIsEva(0);
                }


            }
        }

        return new PageList<>(result);
    }

    //2024-06-26 20:27
//    @Override
//    public MatApproval quoData(QueryFilter<MatApprovalDetails> queryFilter) {
//        String noticeId = null;
//        String round = "1";
//        List<QueryField> querys = queryFilter.getQuerys();
//        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
//            for(QueryField qf : querys){
//                if(qf.getProperty().equalsIgnoreCase("noticeId")){
//                    noticeId = String.valueOf(qf.getValue());
//                }
//            }
//        }
//        MatApproval notice = approvalManager.getById(noticeId);
//        //查询报价模版明细
////        LambdaQueryWrapper<QuotationTemplateDetail> quoTemplateQW = new LambdaQueryWrapper<>();
////        quoTemplateQW.eq(QuotationTemplateDetail::getTemplateId,notice.getQuotationTemplate())
////                .eq(QuotationTemplateDetail::getIsDele,"0");
////        notice.setQuotationTemplateDetailList(quotationTemplateDetailManager.list(quoTemplateQW));
//
//        //查询招标/补遗文件
//        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
//        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,noticeId)
//                .eq(TenderDocument::getProjectApprovalType,1)
//                .isNotNull(TenderDocument::getType)
//                .eq(TenderDocument::getIsDele,"0");
//        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);
//
//        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
//            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
//
//            //招标文件
//            List<TenderDocument> zbDocument = collect.get(1);
//            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
//                TenderDocument tenderDocument = zbDocument.get(0);
//                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
//                notice.setZbDocument(tenderDocument);
//            }
//
//            //补遗文件
//            List<TenderDocument> byDocument = collect.get(2);
//            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
//                byDocument.stream().forEach(s->{
//                    s.setAccessoryList(accessoryService.getAccessoryBySourceId(s.getId()));
//                });
//                notice.setByDocument(byDocument);
//            }
//
//        }
//
//        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
//        List<MatApprovalDetails> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0,-1,false)),
//                convert2Wrapper(queryFilter, currentModelClass())).getRecords();
//
//        //获取每个明细id和最低报价
//        Map<String, Map<String, String>> groupMinPrice = quotationManager.getGroupMinPrice(noticeId, round,"1");
//
//        if(BeanUtil.isNotEmpty(records) && records.size()>0){
//            for(MatApprovalDetails hd : records){
//                String hId = hd.getId();
//                //判断该详细在报价表里是否有报价
//                if(groupMinPrice.containsKey(hId)){
//                    Map<String, String> map = groupMinPrice.get(hId);
//                    if(BeanUtils.isNotEmpty(map.get("minPrice"))) {
//                        String minPrice = String.valueOf(map.get("minPrice"));
//                        hd.setMinQuoPrice(new BigDecimal(minPrice));
//                    }
////                    hd.setMinQuoPrice(BeanUtil.isNotEmpty(minPrice)
////                            ?new BigDecimal(minPrice): BigDecimal.ZERO);
//                }
////                else {
////                    hd.setMinQuoPrice(BigDecimal.ZERO);
////                }
//
//                //获取报价表中当前用户的报价
//                LambdaQueryWrapper<BizBiddingQuotation> quoQW= new LambdaQueryWrapper<>();
//                quoQW.eq(BizBiddingQuotation::getQuotationRounds,round)
//                        .eq(BizBiddingQuotation::getNoticeDetailedId,hId)
//                        .eq(BizBiddingQuotation::getNoticeType,"1")
//                        .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
//                        .orderByDesc(BizBiddingQuotation::getCreateTime)
//                        .last("limit 1");
//                BizBiddingQuotation quotation = quotationManager.getBaseMapper().selectOne(quoQW);
//
//                if(BeanUtils.isNotEmpty(quotation)){
//                    if(BeanUtils.isNotEmpty(quotation.getQuotationPrice())){
//                        hd.setMyPrice(quotation.getQuotationPrice());
//                    }
//
//                    //查询报价模版明细
//                    QueryFilter<QuotationTemplateDetail> quoTemplateQF = QueryFilter.build();
//                    quoTemplateQF.addFilter("a.TEMPLATE_ID_",notice.getQuotationTemplate(),QueryOP.EQUAL);
//                    quoTemplateQF.addFilter("b.QUOTATION_ID_",quotation.getId(),QueryOP.EQUAL);
//                    quoTemplateQF.setPageBean(new PageBean(0,-1,false));
//                    hd.setQuotationTemplateDetailList(quotationTemplateDetailManager.queryQuoValueByPage(quoTemplateQF).getRows());
//                }
////                else {
////                    hd.setMyPrice(BigDecimal.ZERO);
////                }
//
//            }
//        }
//
//        notice.setDetailsList(records);
//        return notice;
//    }

    //2024-06-26 21:52
//    @Override
//    public MatApproval quoManageData(QueryFilter<MatApprovalDetails> queryFilter) {
//        String noticeId = null;
//        String round = "1";
//        List<QueryField> querys = queryFilter.getQuerys();
//        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
//            for(QueryField qf : querys){
//                if(qf.getProperty().equalsIgnoreCase("noticeId")){
//                    noticeId = String.valueOf(qf.getValue());
//                }
//            }
//        }
//        MatApproval notice = approvalManager.getById(noticeId);
//
//        //查询招标/补遗文件
////        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
////        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,noticeId)
////                .eq(TenderDocument::getProjectApprovalType,1)
////                .isNotNull(TenderDocument::getType)
////                .eq(TenderDocument::getIsDele,"0");
////        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);
////
////        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
////            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
////
////            //招标文件
////            List<TenderDocument> zbDocument = collect.get(1);
////            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
////                TenderDocument tenderDocument = zbDocument.get(0);
////                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
////                notice.setZbDocument(tenderDocument);
////            }
////
////            //补遗文件
////            List<TenderDocument> byDocument = collect.get(2);
////            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
////                TenderDocument tenderDocument = byDocument.get(0);
////                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
////                notice.setByDocument(tenderDocument);
////            }
////
////        }
//
//        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
//        List<MatApprovalDetails> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0,-1,false)),
//                convert2Wrapper(queryFilter, currentModelClass())).getRecords();
//
//        //获取每个明细id和最低报价
//        Map<String, Map<String, String>> groupMinPrice = quotationManager.getGroupMinPrice(noticeId, round,"1");
//
//        if(BeanUtil.isNotEmpty(records) && records.size()>0){
//            for(MatApprovalDetails hd : records){
//                String hId = hd.getId();
//                //判断该详细在报价表里是否有报价
//                if(groupMinPrice.containsKey(hId)){
//                    Map<String, String> map = groupMinPrice.get(hId);
//                    String minPrice = String.valueOf(map.get("minPrice"));
//                    if(BeanUtils.isNotEmpty(minPrice)) hd.setMinQuoPrice(new BigDecimal(minPrice));
////                    hd.setMinQuoPrice(BeanUtil.isNotEmpty(minPrice)
////                            ?new BigDecimal(minPrice): BigDecimal.ZERO);
//                }
////                else {
////                    hd.setMinQuoPrice(BigDecimal.ZERO);
////                }
//            }
//        }
//
//        notice.setDetailsList(records);
//        return notice;
//    }

    @Override
    public MatApproval quoData(QueryFilter<MatApprovalDetails> queryFilter) {
        String noticeId = null;
        Integer round = 1;
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equalsIgnoreCase("noticeId")){
                    noticeId = String.valueOf(qf.getValue());
                }
            }
        }
        MatApproval notice = approvalManager.getById(noticeId);
        round = notice.getQuotationRoundsNum();
        //查询报价模版明细
//        LambdaQueryWrapper<QuotationTemplateDetail> quoTemplateQW = new LambdaQueryWrapper<>();
//        quoTemplateQW.eq(QuotationTemplateDetail::getTemplateId,notice.getQuotationTemplate())
//                .eq(QuotationTemplateDetail::getIsDele,"0");
//        notice.setQuotationTemplateDetailList(quotationTemplateDetailManager.list(quoTemplateQW));

        //查询招标/补遗文件
//        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
//        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,noticeId)
//                .eq(TenderDocument::getProjectApprovalType,1)
//                .eq(TenderDocument::getReleaseStatus,2)
//                .isNotNull(TenderDocument::getType)
//                .eq(TenderDocument::getIsDele,"0");
//        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);
//
//        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
//            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
//
//            //招标文件
//            List<TenderDocument> zbDocument = collect.get(1);
//            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
//                TenderDocument tenderDocument = zbDocument.get(0);
//                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
//                notice.setZbDocument(tenderDocument);
//            }
//
//            //补遗文件
//            List<TenderDocument> byDocument = collect.get(2);
//            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
//                byDocument.stream().forEach(s->{
//                    s.setAccessoryList(accessoryService.getAccessoryBySourceId(s.getId()));
//                });
//                notice.setByDocument(byDocument);
//            }
//
//        }

        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<MatApprovalDetails> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0,-1,false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        //获取每个明细id和最低报价
//        Map<String, Map<String, String>> groupMinPrice = new HashMap<>();
//        if(notice.getProcureType()==3){
//            groupMinPrice = quotationManager.getGroupMinPrice(noticeId, String.valueOf(notice.getQuotationRoundsNum()),"1");
//        }

        if(BeanUtil.isNotEmpty(records) && records.size()>0){
            for(MatApprovalDetails hd : records){
                String hId = hd.getId();

                //获取报价表中当前用户的报价
                LambdaQueryWrapper<BizBiddingQuotation> quoQW= new LambdaQueryWrapper<>();
                quoQW.eq(BizBiddingQuotation::getNoticeDetailedId,hId)
                        .eq(BizBiddingQuotation::getNoticeType,"1")
                        .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
                        .orderByAsc(BizBiddingQuotation::getCreateTime);
                List<BizBiddingQuotation> quoList = quotationManager.list(quoQW);

                //查询报价模版明细
                LambdaQueryWrapper<QuotationTemplateDetail> quoTemplateQW = new LambdaQueryWrapper<>();
                quoTemplateQW.eq(QuotationTemplateDetail::getTemplateId,notice.getQuotationTemplate())
                        .eq(QuotationTemplateDetail::getIsDele,"0");
                List<QuotationTemplateDetail> quotationTemplateDetails = quotationTemplateDetailManager.list(quoTemplateQW);

                if(BeanUtils.isNotEmpty(quoList) && quoList.size()>0){
                    int r = 1;
                    for(BizBiddingQuotation quotation : quoList){
                        LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
                        templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,quotation.getId());
                        List<BiddingQuotationTemplateDetailData> templateDataList = biddingQuotationTemplateDetailDataManager.list(templateDataQW);

                        if(quotation.getQuotationRounds().equals(round)){
                            //如果报价为当前轮次
                            if(BeanUtils.isNotEmpty(quotation.getQuotationPrice())){
                                hd.setMyPrice(quotation.getQuotationPrice());
                            }
                            if(BeanUtils.isNotEmpty(quotation.getTenderExplain())){
                                hd.setTenderExplain(quotation.getTenderExplain());
                            }

                            for(QuotationTemplateDetail temp : quotationTemplateDetails){
                                List<String> collect = templateDataList.stream().filter(s -> s.getTemplateDetailId().equals(temp.getId())).map(s -> s.getValue()).collect(Collectors.toList());
                                if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
                                    temp.setValue(collect.get(0));
                                }
                            }
                        }else {
                            for(QuotationTemplateDetail temp : quotationTemplateDetails){
                                List<String> collect = templateDataList.stream().filter(s -> s.getTemplateDetailId().equals(temp.getId())).map(s -> s.getValue()).collect(Collectors.toList());
                                if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
                                    if(r==1){
                                        temp.setQuoValue1(collect.get(0));
                                    }else if(r==2){
                                        temp.setQuoValue2(collect.get(0));
                                    }else if(r==3){
                                        temp.setQuoValue3(collect.get(0));
                                    }else if(r==4){
                                        temp.setQuoValue4(collect.get(0));
                                    }else {
                                        temp.setValue(collect.get(0));
                                    }
                                }
                            }
                        }
                        r++;
                    }
                }

                if(notice.getProcureType()==3){
                    List<BizBiddingQuotation> rankList = quotationManager.getRankList(noticeId, hId, String.valueOf(notice.getQuotationRoundsNum()), "1");
                    //判断该详细在报价表里是否有报价
                    if(BeanUtils.isNotEmpty(rankList) && rankList.size()>0) {
                        hd.setMinQuoPrice(rankList.get(0).getQuotationPrice());
                        //设置当前报价排名
                        if(BeanUtils.isNotEmpty(hd.getMyPrice())){
                            Integer rank = rankList.stream().filter(s -> s.getQuotationCompanyId().equals(ContextUtil.getCurrentOrgId()) && s.getQuotationPrice().compareTo(hd.getMyPrice()) == 0)
                                    .map(s -> s.getRank()).collect(Collectors.toList()).get(0);
                            hd.setRank(rank);
                        }
                    }
                }
                hd.setQuotationTemplateDetailList(quotationTemplateDetails);
            }
        }

        notice.setDetailsList(records);
        return notice;
    }

    @Override
    public MatApproval quoManageData(QueryFilter<MatApprovalDetails> queryFilter) {
        String noticeId = null;
        Integer round = 1;
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equalsIgnoreCase("noticeId")){
                    noticeId = String.valueOf(qf.getValue());
                }
            }
        }
        MatApproval notice = approvalManager.getById(noticeId);

        //查询招标/补遗文件
//        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
//        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,noticeId)
//                .eq(TenderDocument::getProjectApprovalType,1)
//                .isNotNull(TenderDocument::getType)
//                .eq(TenderDocument::getIsDele,"0");
//        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);
//
//        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
//            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
//
//            //招标文件
//            List<TenderDocument> zbDocument = collect.get(1);
//            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
//                TenderDocument tenderDocument = zbDocument.get(0);
//                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
//                notice.setZbDocument(tenderDocument);
//            }
//
//            //补遗文件
//            List<TenderDocument> byDocument = collect.get(2);
//            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
//                TenderDocument tenderDocument = byDocument.get(0);
//                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
//                notice.setByDocument(tenderDocument);
//            }
//
//        }

        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<MatApprovalDetails> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0,-1,false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        //获取每个明细id和最低报价
        Map<String, Map<String, String>> groupMinPrice = quotationManager.getGroupMinPrice(noticeId, String.valueOf(round),"1");

        if(BeanUtil.isNotEmpty(records) && records.size()>0){
            for(MatApprovalDetails hd : records){
                String hId = hd.getId();
                //判断该详细在报价表里是否有报价
                if(groupMinPrice.containsKey(hId)){
                    Map<String, String> map = groupMinPrice.get(hId);
                    if(BeanUtils.isNotEmpty(map.get("minPrice"))){
                        String minPrice = String.valueOf(map.get("minPrice"));
                        hd.setMinQuoPrice(new BigDecimal(minPrice));
                    }
//                    hd.setMinQuoPrice(BeanUtil.isNotEmpty(minPrice)
//                            ?new BigDecimal(minPrice): BigDecimal.ZERO);
                }

                //获取报价表中当前明细的报价
                LambdaQueryWrapper<BizBiddingQuotation> quoQW = new LambdaQueryWrapper<>();
                quoQW.eq(BizBiddingQuotation::getNoticeDetailedId,hId)
                        .eq(BizBiddingQuotation::getNoticeType,"1")
                        .orderByAsc(BizBiddingQuotation::getCreateTime);
                List<BizBiddingQuotation> quoList = quotationManager.list(quoQW);

                //查询报价模版明细
                LambdaQueryWrapper<QuotationTemplateDetail> quoTemplateQW = new LambdaQueryWrapper<>();
                quoTemplateQW.eq(QuotationTemplateDetail::getTemplateId,notice.getQuotationTemplate())
                        .eq(QuotationTemplateDetail::getIsDele,"0");
                List<QuotationTemplateDetail> quotationTemplateDetails = quotationTemplateDetailManager.list(quoTemplateQW);

                if(BeanUtils.isNotEmpty(quoList) && quoList.size()>0){
                    int r = 1;
                    for(BizBiddingQuotation quotation : quoList){
                        LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
                        templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,quotation.getId());
                        List<BiddingQuotationTemplateDetailData> templateDataList = biddingQuotationTemplateDetailDataManager.list(templateDataQW);

                        if(quotation.getQuotationRounds().equals(round)){
                            //如果报价为当前轮次
                            if(BeanUtils.isNotEmpty(quotation.getQuotationPrice())){
                                hd.setMyPrice(quotation.getQuotationPrice());
                            }
                            if(BeanUtils.isNotEmpty(quotation.getTenderExplain())){
                                hd.setTenderExplain(quotation.getTenderExplain());
                            }

                            for(QuotationTemplateDetail temp : quotationTemplateDetails){
                                List<String> collect = templateDataList.stream().filter(s -> s.getTemplateDetailId().equals(temp.getId())).map(s -> s.getValue()).collect(Collectors.toList());
                                if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
                                    temp.setValue(collect.get(0));
                                }
                            }
                        }else {
                            for(QuotationTemplateDetail temp : quotationTemplateDetails){
                                List<String> collect = templateDataList.stream().filter(s -> s.getTemplateDetailId().equals(temp.getId())).map(s -> s.getValue()).collect(Collectors.toList());
                                if(BeanUtils.isNotEmpty(collect) && collect.size()>0){
                                    if(r==1){
                                        temp.setQuoValue1(collect.get(0));
                                    }else if(r==2){
                                        temp.setQuoValue2(collect.get(0));
                                    }else if(r==3){
                                        temp.setQuoValue3(collect.get(0));
                                    }else if(r==4){
                                        temp.setQuoValue4(collect.get(0));
                                    }else {
                                        temp.setValue(collect.get(0));
                                    }
                                }
                            }
                        }
                        r++;
                    }

                    hd.setQuotationTemplateDetailList(quotationTemplateDetails);

                }

            }
        }

//                else {
//                    hd.setMinQuoPrice(BigDecimal.ZERO);
//                }

        notice.setDetailsList(records);
        return notice;
    }

    @Override
    public PageList<MatApprovalDetails> bidOpenManageData(QueryFilter<MatApprovalDetails> queryFilter) {
        queryFilter.addFilter("quo.NOTICE_TYPE_","1", QueryOP.EQUAL);
        queryFilter.addFilter("detail.IS_DELE_","0", QueryOP.EQUAL);
        IPage<MatApprovalDetails> result = baseMapper.quoDataQuery(convert2IPage(new PageBean(0, -1, false)),
                convert2Wrapper(queryFilter, currentModelClass()));

        //获取每个明细id和最低报价
//        Map<String, Map<String, String>> groupMinPrice = quotationManager.getGroupMinPrice(noticeId, round,"1");
//        if(BeanUtil.isNotEmpty(records) && records.size()>0){
//            for(MatApprovalDetails hd : records){
//                String hId = hd.getId();
//                //判断该详细在报价表里是否有报价
//                if(groupMinPrice.containsKey(hId)){
//                    Map<String, String> map = groupMinPrice.get(hId);
//                    String minPrice = String.valueOf(map.get("minPrice"));
//                    if(BeanUtils.isNotEmpty(minPrice)) hd.setMinQuoPrice(new BigDecimal(minPrice));
//                }
//            }
//        }

        return new PageList<>(result);
    }

    @Override
    public PageList<MatApprovalDetails> pageEvaData(QueryFilter<MatApprovalDetails> queryFilter) {
        queryFilter.addFilter("detail.IS_DELE_","0",QueryOP.EQUAL);
        IPage<MatApprovalDetails> result = baseMapper.queryEvaData(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public List<MatApprovalDetails> excelToData(MultipartFile file) throws Exception {
        List<MatApprovalDetails> data = new ArrayList<>();
        List<MatApprovalDetailsImportVO> voList = ExcelImportUtil.importExcel(file.getInputStream(), MatApprovalDetailsImportVO.class, new ImportParams());

        if(BeanUtils.isNotEmpty(voList) && voList.size()>0){
            for(MatApprovalDetailsImportVO vo : voList){
                MatApprovalDetails temp = new MatApprovalDetails();
                BeanUtils.copyNotNullProperties(temp,vo);

                //1.根据平台物料编号查询物料表
                if (BeanUtils.isEmpty(temp.getMatPlatcode())) {
                    throw new BaseException("请填入平台物料编号");
                }
                if (BeanUtils.isEmpty(temp.getMatCompanyCode())){
                    throw new BaseException("请填入需求企业编号");
                }
                if (BeanUtils.isEmpty(temp.getDemandDateValue())){
                    throw new BaseException("请填入需求日期");
                }
                if (BeanUtils.isEmpty(temp.getMatNum())){
                    throw new BaseException("请填入数量");
                }
                if (BeanUtils.isEmpty(temp.getPlanCode())){
                    throw new BaseException("请填入计划编号");
                }

                LocalDate date = null;
                try {
                    date = LocalDate.parse(temp.getDemandDateValue());
                }catch (Exception e){
                    System.out.println("需求日期转换错误："+e.getMessage());
                    throw new BaseException("请检查需求日期格式【"+temp.getDemandDateValue()+"】，正确格式示例【2024-08-14】");
                }

                if(date.isBefore(LocalDate.now())){
                    throw new BaseException("需求日期【"+date+"】不能在当前日期之前");
                }
                temp.setDemandDate(date);

                Enterprise enterprise = enterpriseManager.getByCodeOrHisCode(temp.getMatCompanyCode());
                if(BeanUtils.isEmpty(enterprise)){
                    throw new BaseException("需求企业信息未找到，请检查企业编号【"+temp.getMatCompanyCode()+"】是否正确，如编号正确请前往主数据平台推送企业");
                }

                temp.setMatPlatcode(temp.getMatPlatcode().trim());
                LambdaQueryWrapper<BizMaterial> materialQW = new LambdaQueryWrapper<>();
                materialQW.eq(BizMaterial::getMatPlatcode,temp.getMatPlatcode())
                        .and(s->s.eq(BizMaterial::getMatCompanyCode,enterprise.getCompanyCode())
                                .or(BeanUtils.isNotEmpty(enterprise.getHistoryCompanyCode()))
                                .eq(BizMaterial::getMatCompanyCode,enterprise.getHistoryCompanyCode()))
                        .eq(BizMaterial::getIsDele,"0")
                        .orderByDesc(BizMaterial::getCreateTime)
                        .last("limit 1");
                BizMaterial material = materialManager.getBaseMapper().selectOne(materialQW);
                if(BeanUtils.isEmpty(material)){
                    throw new BaseException("平台物料编号【"+temp.getMatPlatcode()+"】未找到企业物料，请输入正确的平台物料编号或生成企业物料");
                }

                temp.setMatCompanyId(enterprise.getOrgId());
                temp.setMatCompanyCode(enterprise.getCompanyCode());
                temp.setMatCompanyName(enterprise.getCompanyName());

                //赋值物料属性
                temp.setMatId(material.getId());
                temp.setMatCompanyId(material.getMatCompanyId());
                temp.setMatCompanyCode(material.getMatCompanyCode());
//                temp.setMatCompanyName(material.getMatCompanyName());
                temp.setMatCategoryCode(material.getMatCategory());
                temp.setMatCode(material.getMatCode());
                temp.setMatName(material.getMatName());
                temp.setMatMaterial(material.getMatMaterial());
                temp.setMatSpec(material.getMatSpec());
                temp.setMatBrand(material.getMatBrand());
                temp.setMatBaseExt(material.getMatBaseExt());
                temp.setMatOtherExt(material.getMatOtherExt());
                temp.setMatUnit(material.getMatUnit());
                temp.setTaxRate(material.getMatTaxrate());

                //根据送货地址编号获取地址
//                if(BeanUtils.isNotEmpty(temp.getUnloadAddress())){
//                    LambdaQueryWrapper<BizDeliveryAddress> addressQW = new LambdaQueryWrapper<>();
//                    addressQW.eq(BizDeliveryAddress::getEnterpriseId, ContextUtil.getCurrentOrgId())
//                            .eq(BizDeliveryAddress::getCode,temp.getUnloadAddress())
//                            .eq(BizDeliveryAddress::getIsDele,"0")
//                            .orderByDesc(BizDeliveryAddress::getCreateTime)
//                            .last("limit 1");
//                    BizDeliveryAddress address = addressManager.getBaseMapper().selectOne(addressQW);
//                    if(BeanUtils.isNotEmpty(address)){
//                        temp.setUnloadAddress(address.getEnterpriseContactAddress());
//                    }
//                }

                data.add(temp);
            }
        }

        return data;
    }

    @Override
    public List<Map<String, String>> excelTemplateToData(MultipartFile file) {
        List<Map<String, String>> maps = ExcelUtil.ImportDate(file,false,1);

        if(BeanUtils.isNotEmpty(maps) && maps.size()>0){
            for(Map<String, String> map : maps){
                String dataId = map.get("标的ID");
                map.forEach((key,value)->{
                    if(key.contains("元") || key.contains("单价")){
                        try {
                            if(BeanUtils.isNotEmpty(value)){
                                new BigDecimal(value);
                            }
                        } catch (Exception e){
                            String errMes = "";
                            if(BeanUtils.isNotEmpty(dataId)){
                                errMes = "标的ID【"+dataId+"】";
                            }
                            System.out.println("请修正"+errMes+"列【"+key+"】数据【"+value+"】格式为数值型");
                            throw new BaseException("请修正"+errMes+"列【"+key+"】数据【"+value+"】格式为数值型");
                        }
                    }
                });
            }

        }

        return maps;
    }

    @Override
    public void exportTemplateToExcel(QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws Exception {
        String noticeId = null;
        String round = "1";
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equalsIgnoreCase("noticeId")){
                    noticeId = String.valueOf(qf.getValue());
                }
            }
        }
        MatApproval notice = approvalManager.getById(noticeId);
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<MatApprovalDetails> records = baseMapper.queryAllByPage(convert2IPage(new PageBean(0,-1,false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        //查询报价模版
        LambdaQueryWrapper<QuotationTemplateDetail> templateQW = new LambdaQueryWrapper<>();
        templateQW.eq(QuotationTemplateDetail::getTemplateId,notice.getQuotationTemplate())
                .eq(QuotationTemplateDetail::getIsDele,"0");
        List<QuotationTemplateDetail> quoTemplateDetail = quotationTemplateDetailManager.list(templateQW);


        if(BeanUtils.isEmpty(records) || records.size()<=0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        List<Map<String,Object>> dataMapList = new ArrayList<>();
        records.forEach(s->{
            Map<String,Object> dataMap = new HashMap<>();
            dataMap.put("detailId",s.getId());
            dataMap.put("matPlatCode",s.getMatPlatcode());
            dataMap.put("matName",s.getMatName());
            dataMap.put("matMaterial",s.getMatMaterial());
            dataMap.put("matSpec",s.getMatSpec());
            dataMap.put("matUnit",s.getMatUnit());
            dataMap.put("address",s.getUnloadAddress());
            dataMap.put("baseExt",s.getMatBaseExt());
            dataMap.put("otherExt",s.getMatOtherExt());
            dataMap.put("matNum",s.getMatNum());
            dataMap.put("matCompanyName",s.getMatCompanyName());
            dataMap.put("companyRemarks",s.getRemarks());
            dataMap.put("planCode",s.getPlanCode());
            dataMap.put("maximumPriceLimit",s.getMaximumPriceLimit());
            dataMapList.add(dataMap);
        });

        String fileName = "报价导入模版";

        //必填列
        List<String> requiredList = new ArrayList<>();
        //输入列
        List<String> inputList = new ArrayList<>();
        //需要转换格式的列，值为1代表转数值
        HashMap<String, Integer> formatMap = new HashMap<>();

        Map<String, String> exportMaps = new LinkedHashMap<>();
        exportMaps.put("detailId","标的ID");
        exportMaps.put("matPlatCode","平台物料编号");
        exportMaps.put("matName","物料名称");
        exportMaps.put("matMaterial","物料牌号");
        exportMaps.put("matSpec","规格型号");
        exportMaps.put("matUnit","计量单位");
        exportMaps.put("address","交货地址");
        exportMaps.put("baseExt","基础扩展");
        exportMaps.put("otherExt","其他扩展");
        exportMaps.put("matNum","预计需求数量");
        exportMaps.put("matCompanyName","需求单位");
        exportMaps.put("companyRemarks","企业补充说明");
        exportMaps.put("planCode","计划编号");
        exportMaps.put("maximumPriceLimit","最高限价");
//        exportMaps.put("isQuo","是否报价");
//        inputList.add("isQuo");
//        requiredList.add("isQuo");

        quoTemplateDetail.forEach(s->{
            if(s.getThrowEntry().equals(true)){
                exportMaps.put(s.getId(),s.getQuoArrange());
                inputList.add(s.getId());
            }
            if(s.getIsRequired().equals(true)){
                requiredList.add(s.getId());
            }
            if(s.getPriceEntry()==1){
                formatMap.put(s.getId(),1);
            }
        });
        exportMaps.put("quoRemarks","投标补充说明");
        inputList.add("quoRemarks");

        // 导出下载excel文件
        HSSFWorkbook workbook = ExcelUtil.exportExcel(fileName, 24, exportMaps, dataMapList, 1,notice.getNoticeTitle()+"（黄底色为必填项）",requiredList,inputList,formatMap,6);

        ExcelUtil.downloadExcel(workbook, fileName, response);

    }


    @Override
    public void exportDataToExcel(QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "报价明细-导出结果";
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<MatApprovalDetailsExportVO> data = baseMapper.queryVoByPage(convert2IPage(new PageBean(0,-1,false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        if(BeanUtils.isEmpty(data) || data.size()==0) {
            throw new RuntimeException("没有要导出的的数据！");
        }
        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams,MatApprovalDetailsExportVO.class,data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void exportEvaDataToExcel(QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "评标明细-导出结果";
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        List<MatApprovalDetailsEvaExportVO> data = baseMapper.queryEvaExportVoByPage(convert2IPage(new PageBean(0, -1, false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        if(BeanUtils.isEmpty(data) || data.size()==0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        for(MatApprovalDetailsEvaExportVO temp : data){
            //查询评标信息
            LambdaQueryWrapper<BizBidEvaluation> bidEvaQW = new LambdaQueryWrapper<>();
            bidEvaQW.eq(BizBidEvaluation::getNoticeDetailedId,temp.getId())
                    .eq(BizBidEvaluation::getIsDele,"0")
                    .orderByDesc(BizBidEvaluation::getOperateTime)
                    .last("limit 1");
            BizBidEvaluation bidEva = bidEvaManager.getBaseMapper().selectOne(bidEvaQW);
            if(BeanUtils.isNotEmpty(bidEva)){
                temp.setQuoCompanyName(bidEva.getQuotationOrgName());
                temp.setPrice(bidEva.getQuotationPrice());
                temp.setAmount(bidEva.getQuotationAmount());
                temp.setTenderExplain(bidEva.getTenderExplain());
            }
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams,MatApprovalDetailsEvaExportVO.class,data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

}
