package com.artfess.cgpt.purchasing.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.PurchasingRules;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/5/21 10:35
 */
public interface PurchasingRulesManager extends BaseManager<PurchasingRules> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<PurchasingRules> queryAllByPage(QueryFilter<PurchasingRules> queryFilter);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    PurchasingRules getDetailById(String id);

    void saveOrUpdateEntity(PurchasingRules entity);

    void removeDataByIds(List<String> ids);

    /**
     * 是否需要走流程
     * @param orgId 公司id
     * @param menuAlia 菜单别名
     */
    Boolean isAuditing(String orgId,String menuAlia);

}
