package com.artfess.cgpt.purchasing.manager;

import cn.hutool.json.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 采购申请表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
public interface PurchasingApplicationManager extends BaseManager<PurchasingApplication> {

    /**
     * 分页查询当前公司数据
     * @param queryFilter
     * @return
     */
    PageList<PurchasingApplication> curOrgData(QueryFilter<PurchasingApplication> queryFilter);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<PurchasingApplication> queryAllByPage(QueryFilter<PurchasingApplication> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    String saveOrUpdateEntity(PurchasingApplication entity);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    PurchasingApplication getDataById(String id);

    /**
     * 根据id集合删除数据
     */
    void removeByIds(List<String> ids);

    /**
     * 根据ID更新状态
     * @param ids
     * @param status
     */
    void updateStatus(String ids,String status);

    /**
     * 根据ID修改状态（只修改状态）
     * @param ids
     * @param status
     */
    void modifyStatusById(String ids,String status);

    /**
     * 保存或更新数据（api）
     * @param param
     * @return
     */
    Response saveOrUpdateByApi(JSONObject param);

}
