package com.artfess.cgpt.purchasing.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 10:22
 */
public interface MatApprovalDetailsManager extends BaseManager<MatApprovalDetails> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<MatApprovalDetails> queryAllByPage(QueryFilter<MatApprovalDetails> queryFilter);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<MatApprovalDetails> pageEvaDetail(QueryFilter<MatApprovalDetails> queryFilter);

    /**
     * 报价明细
     * @param queryFilter
     * @return
     */
    MatApproval quoData(QueryFilter<MatApprovalDetails> queryFilter);

    /**
     * 报价管理-明细
     * @param queryFilter
     * @return
     */
    MatApproval quoManageData(QueryFilter<MatApprovalDetails> queryFilter);

    /**
     * 开票管理-报价明细
     * @param queryFilter
     * @return
     */
    PageList<MatApprovalDetails> bidOpenManageData(QueryFilter<MatApprovalDetails> queryFilter);

    /**
     * 分页查询评标明细
     * @param queryFilter
     * @return
     */
    PageList<MatApprovalDetails> pageEvaData(QueryFilter<MatApprovalDetails> queryFilter);

    /**
     * 根据Excel文件转换数据（采购立项明细）
     * @param file 文件
     * @throws Exception
     */
    List<MatApprovalDetails> excelToData(MultipartFile file) throws Exception;

    /**
     * 根据Excel文件转换数据（报价模版导入）
     * @param file 文件
     * @throws Exception
     */
    List<Map<String, String>> excelTemplateToData(MultipartFile file);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportTemplateToExcel(QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws Exception;


    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportEvaDataToExcel(QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws IOException;

}
