package com.artfess.cgpt.purchasing.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.ClarifyAnswer;
import com.artfess.cgpt.purchasing.model.ClarifyQuestions;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/27 17:53
 */
public interface ClarifyAnswerManager extends BaseManager<ClarifyAnswer> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<ClarifyAnswer> queryAllByPage(QueryFilter<ClarifyAnswer> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(ClarifyAnswer entity);

    /**
     * 根据提问id查询所有回答
     * @param questionId 提问id
     * @return
     */
    List<ClarifyAnswer> getByQuestionId(String questionId);

}
