package com.artfess.cgpt.purchasing.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrder;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 采购订单表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
public interface BizPurchaseOrderManager extends BaseManager<BizPurchaseOrder> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizPurchaseOrder> queryAllByPage(QueryFilter<BizPurchaseOrder> queryFilter);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizPurchaseOrder getDetailById(String id);

    /**
     * 根据id集合删除
     * @param ids
     */
    void removeData(List<String> ids);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveVo(BizPurchaseOrder entity);

    /**
     * 修改状态
     * @param ids
     * @param status
     */
    void confirmOrder(String ids,String status);

    /**
     * 分页查询采购商分组
     * @param queryFilter
     * @return
     */
    PageList<BizPurchaseOrder> pageMatCompanyGroup(QueryFilter<BizPurchaseOrder> queryFilter);

}
