package com.artfess.cgpt.purchasing.dao;

import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 9:39
 */
public interface MatApprovalDao extends BaseMapper<MatApproval> {

    /**
     * 根据id查询数据（不加租户过滤）
     * @param id
     * @return
     */
    @SqlParser(filter=true)
    MatApproval getByIdNoTenantId(@Param("id")String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApproval> queryAllByPage(IPage<MatApproval> convert2IPage, @Param("ew") Wrapper<MatApproval> convert2Wrapper);

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApproval> queryAndvalidityDate(IPage<MatApproval> convert2IPage, @Param("ew") Wrapper<MatApproval> convert2Wrapper);

    /**
     * 查询所有数据ID
     * @param convert2Wrapper
     * @return
     */
    List<String> queryIds(@Param("ew") Wrapper<MatApproval> convert2Wrapper);

    /**
     * 参与报名-分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApproval> getSignData(IPage<MatApproval> convert2IPage,
                                   @Param("ew") Wrapper<MatApproval> convert2Wrapper);

    /**
     * 我的报价-分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<MatApproval> getQuoData(IPage<MatApproval> convert2IPage, @Param("ew") Wrapper<MatApproval> convert2Wrapper);

}
