package com.artfess.cgpt.purchasing.controller;


import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.TenderDocument;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.purchasing.model.TenderDocumentConfirm;
import com.artfess.cgpt.purchasing.manager.TenderDocumentConfirmManager;

import java.util.Arrays;
import java.util.List;

/**
 * 招标/补遗 文件确认表 前端控制器
 *
 * @company artfess.com
 * @author baseli
 * @since 2024-08-15
 */
@RestController
@RequestMapping("/purchasing/bizTenderDocumentConfirm/v1/")
public class TenderDocumentConfirmController extends BaseController<TenderDocumentConfirmManager, TenderDocumentConfirm> {

    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody TenderDocumentConfirm t) {
        boolean result = baseService.save(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<TenderDocumentConfirm> query(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<TenderDocumentConfirm> queryFilter) {
        return baseService.query(queryFilter);
    }

    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public TenderDocumentConfirm getById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        return baseService.getById(id);
    }

    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody TenderDocumentConfirm t) {
        boolean result = baseService.updateById(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }

    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="实体集合") @RequestParam String...ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/saveList")
    @ApiOperation(value = "M-批量保存数据")
    public CommonResult saveList(@RequestBody List<TenderDocumentConfirm> data) {
        baseService.saveList(data);
        return new CommonResult<>(true, "操作成功");
    }

}
